/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.janus.model.impl;

import com.alibaba.fastjson.JSON;
import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.LogEvent;
import com.xforceplus.xlog.core.model.MethodEventListener;
import com.xforceplus.xlog.core.model.impl.JanusProducerLogEvent;
import com.xforceplus.xlog.core.model.setting.XlogJanusSettings;
import com.xforceplus.xlog.core.utils.ExceptionUtil;
import com.xforceplus.xlog.logsender.model.LogSender;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public class JanusProducerListenerImpl
extends MethodEventListener {
    private static final ThreadLocal<JanusProducerLogEvent> cache = new ThreadLocal();
    private final LogSender logSender;
    private final String storeName;
    private final XlogJanusSettings janusSettings;

    public JanusProducerListenerImpl(LogSender logSender, String storeName, XlogJanusSettings janusSettings) {
        this.logSender = logSender;
        this.storeName = storeName;
        this.janusSettings = janusSettings;
    }

    public void beforeCall(Object target, LogEvent logEvent, Object[] args) {
        if (!(logEvent instanceof JanusProducerLogEvent)) {
            return;
        }
        JanusProducerLogEvent event = (JanusProducerLogEvent)logEvent;
        String traceId = LogContext.getTraceId();
        event.setStoreName(this.storeName);
        event.setTraceId(traceId);
        event.setParentTraceId(LogContext.getParentTraceId());
        event.setTenantInfo(LogContext.getTenantInfo());
        Optional.ofNullable(this.janusSettings).map(XlogJanusSettings::getProducer).ifPresent(producer -> event.setLimitSize(producer.getLimitSize()));
        try {
            SealedMessage sealedMessage = (SealedMessage)args[0];
            event.setName(sealedMessage.getHeader().getRequestName());
            String messageText = JSON.toJSONString((Object)sealedMessage.getPayload().getObj());
            event.setMessageText(messageText);
            event.setMessageTextSize(messageText.getBytes(StandardCharsets.UTF_8).length);
            event.setMessageProperties(JSON.toJSONString((Object)sealedMessage.getHeader().getOthers()));
            event.setMessageId(sealedMessage.getHeader().getMsgId());
        }
        catch (Throwable throwable) {
            event.setWarnMessage("[Before]\u6536\u96c6JanusProducer\u65e5\u5fd7\u6570\u636e\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)throwable));
        }
    }

    public Object afterCall(Object target, LogEvent logEvent, Object[] args, Object result) {
        if (!(logEvent instanceof JanusProducerLogEvent)) {
            return result;
        }
        JanusProducerLogEvent event = (JanusProducerLogEvent)logEvent;
        try {
            boolean response = (Boolean)result;
            event.setSuccessful(response);
        }
        catch (Throwable throwable) {
            event.setWarnMessage("[After]\u6536\u96c6JanusProducer\u65e5\u5fd7\u6570\u636e\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)throwable));
        }
        this.logSender.send((LogEvent)event);
        return result;
    }

    public void onException(Object target, LogEvent logEvent, Throwable ex) {
        if (!(logEvent instanceof JanusProducerLogEvent)) {
            return;
        }
        JanusProducerLogEvent event = (JanusProducerLogEvent)logEvent;
        event.setThrowable(ex);
        this.logSender.send((LogEvent)event);
    }
}

