/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.jooq.model;

import com.alibaba.fastjson.JSON;
import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.LogEvent;
import com.xforceplus.xlog.core.model.impl.JooqLogEvent;
import com.xforceplus.xlog.core.model.setting.XlogJooqSettings;
import com.xforceplus.xlog.core.model.setting.XlogSettings;
import com.xforceplus.xlog.core.utils.ExceptionUtil;
import com.xforceplus.xlog.logsender.model.LogSender;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.annotation.Nullable;
import org.jooq.Configuration;
import org.jooq.Delete;
import org.jooq.ExecuteContext;
import org.jooq.Insert;
import org.jooq.Query;
import org.jooq.QueryPart;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.Update;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultExecuteListener;

public class XlogJooqExecutionListener
extends DefaultExecuteListener {
    private final LogSender logSender;
    private final String storeName;
    private final XlogSettings xlogSettings;

    public XlogJooqExecutionListener(String storeName, LogSender logSender, @Nullable XlogSettings xlogSettings) {
        this.storeName = storeName;
        this.logSender = logSender;
        this.xlogSettings = xlogSettings;
    }

    public void start(ExecuteContext ctx) {
        super.start(ctx);
        Boolean enabled = Optional.ofNullable(this.xlogSettings).map(XlogSettings::getJooq).map(XlogJooqSettings::getEnabled).orElse(true);
        if (!enabled.booleanValue()) {
            return;
        }
        JooqLogEvent event = new JooqLogEvent();
        event.setStoreName(this.storeName);
        event.setTraceId(LogContext.getTraceId());
        event.setParentTraceId(LogContext.getParentTraceId());
        event.setTenantInfo(LogContext.getTenantInfo());
        ctx.data((Object)"event", (Object)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(ExecuteContext ctx) {
        super.end(ctx);
        Boolean enabled = Optional.ofNullable(this.xlogSettings).map(XlogSettings::getJooq).map(XlogJooqSettings::getEnabled).orElse(true);
        if (!enabled.booleanValue()) {
            return;
        }
        JooqLogEvent event = (JooqLogEvent)ctx.data((Object)"event");
        if (event == null) {
            return;
        }
        try {
            Boolean sqlResultEnabled;
            Boolean sqlEnabled = Optional.ofNullable(this.xlogSettings).map(XlogSettings::getJooq).map(XlogJooqSettings::getSqlEnabled).orElse(true);
            if (sqlEnabled.booleanValue()) {
                String sql;
                Query query = ctx.query();
                if (query != null) {
                    event.setName(query.getClass().getSimpleName());
                    event.setSql(DSL.using((Configuration)ctx.configuration()).renderInlined((QueryPart)query));
                }
                if ((sql = event.getSql()) != null) {
                    if (query instanceof Select) {
                        event.setSqlCommandType("SELECT");
                    } else if (query instanceof Update) {
                        event.setSqlCommandType("UPDATE");
                    } else if (query instanceof Insert) {
                        event.setSqlCommandType("INSERT");
                    } else if (query instanceof Delete) {
                        event.setSqlCommandType("DELETE");
                    }
                    if (sql.length() >= 0x100000) {
                        event.setSqlSize(sql.length());
                    } else {
                        event.setSqlSize(sql.getBytes(StandardCharsets.UTF_8).length);
                    }
                }
            }
            if ((sqlResultEnabled = Optional.ofNullable(this.xlogSettings).map(XlogSettings::getJooq).map(XlogJooqSettings::getSqlResultEnabled).orElse(true)).booleanValue()) {
                String sqlResult;
                Result result = ctx.result();
                if (result != null) {
                    event.setSqlResult(JSON.toJSONString((Object)result.intoMaps()));
                }
                if ((sqlResult = event.getSqlResult()) != null) {
                    if (sqlResult.length() >= 0x100000) {
                        event.setSqlResultSize(sqlResult.length());
                    } else {
                        event.setSqlResultSize(sqlResult.getBytes(StandardCharsets.UTF_8).length);
                    }
                }
            }
            event.setRows(ctx.rows());
            if (ctx.exception() != null) {
                event.setThrowable((Throwable)ctx.exception());
            }
        }
        catch (Throwable e) {
            event.setWarnMessage(String.format("\u5904\u7406Jooq\u7684SQL\u6267\u884c\u7ed3\u679c\u65f6\u5f02\u5e38\uff0c%s", ExceptionUtil.toDesc((Throwable)e)));
        }
        finally {
            this.logSender.send((LogEvent)event);
        }
    }
}

