/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.messagebus.model;

import com.alibaba.fastjson.JSON;
import com.xforceplus.janus.message.sdk.RequestMessage;
import com.xforceplus.janus.message.sdk.request.PubRequest;
import com.xforceplus.janus.message.sdk.response.PubResponse;
import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.LogEvent;
import com.xforceplus.xlog.core.model.impl.MessageBusProducerLogEvent;
import com.xforceplus.xlog.core.utils.Callable;
import com.xforceplus.xlog.core.utils.ExceptionUtil;
import com.xforceplus.xlog.logsender.model.LogSender;
import java.nio.charset.StandardCharsets;

public class MessageBusProducerInterceptor {
    private final LogSender logSender;
    private final String storeName;

    public MessageBusProducerInterceptor(LogSender logSender, String storeName) {
        this.logSender = logSender;
        this.storeName = storeName;
    }

    public Object intercept(PubRequest pubRequest, Callable<Object> callable) throws Throwable {
        MessageBusProducerLogEvent event = new MessageBusProducerLogEvent();
        event.setTraceId(LogContext.getTraceId());
        event.setName(pubRequest.getPubCode());
        event.setStoreName(this.storeName);
        this.beforeSend(event, pubRequest);
        try {
            PubResponse result = (PubResponse)callable.call();
            if (result.getSuccess().booleanValue()) {
                event.setMessageId(result.getMessageId());
            } else {
                event.setSuccessful(false);
                event.setMessage(result.getError());
            }
            PubResponse pubResponse = result;
            return pubResponse;
        }
        catch (Throwable throwable) {
            event.setThrowable(new Throwable());
            throw throwable;
        }
        finally {
            this.logSender.send((LogEvent)event);
        }
    }

    private void beforeSend(MessageBusProducerLogEvent event, PubRequest pubRequest) {
        try {
            RequestMessage requestMessage = pubRequest.getRequestMessage();
            String messageText = requestMessage.getContent();
            event.setMessageText(messageText);
            event.setMessageTextSize(messageText.getBytes(StandardCharsets.UTF_8).length);
            event.setBusinessNo((String)requestMessage.getProperties().get("businessNo"));
            event.setMessageProperties(JSON.toJSONString((Object)requestMessage.getProperties()));
        }
        catch (Throwable throwable) {
            event.setMessage("\u6536\u96c6MessageBusProducer\u65e5\u5fd7\u6570\u636e\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)throwable));
        }
    }
}

