/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.messagebus.model.impl;

import com.alibaba.fastjson.JSON;
import com.xforceplus.janus.message.sdk.RequestMessage;
import com.xforceplus.janus.message.sdk.request.PubRequest;
import com.xforceplus.janus.message.sdk.response.PubResponse;
import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.LogEvent;
import com.xforceplus.xlog.core.model.MethodListener;
import com.xforceplus.xlog.core.model.impl.MessageBusProducerLogEvent;
import com.xforceplus.xlog.core.utils.ExceptionUtil;
import com.xforceplus.xlog.logsender.model.LogSender;
import java.nio.charset.StandardCharsets;

public class MessageBusProducerListenerImpl
implements MethodListener {
    private static final ThreadLocal<MessageBusProducerLogEvent> cache = new ThreadLocal();
    private final LogSender logSender;
    private final String storeName;

    public MessageBusProducerListenerImpl(LogSender logSender, String storeName) {
        this.logSender = logSender;
        this.storeName = storeName;
    }

    public void beforeCall(Object[] args) {
        MessageBusProducerLogEvent event = new MessageBusProducerLogEvent();
        cache.set(event);
        String traceId = LogContext.getTraceId();
        event.setStoreName(this.storeName);
        event.setTraceId(traceId);
        try {
            PubRequest pubRequest = (PubRequest)args[0];
            event.setName(pubRequest.getPubCode());
            RequestMessage requestMessage = pubRequest.getRequestMessage();
            String messageText = requestMessage.getContent();
            event.setMessageText(messageText);
            event.setMessageTextSize(messageText.getBytes(StandardCharsets.UTF_8).length);
            event.setBusinessNo((String)requestMessage.getProperties().get("businessNo"));
            event.setMessageProperties(JSON.toJSONString((Object)requestMessage.getProperties()));
        }
        catch (Throwable throwable) {
            event.setMessage("[Before]\u6536\u96c6MessageBusProducer\u65e5\u5fd7\u6570\u636e\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)throwable));
        }
    }

    public void afterCall(Object[] args, Object result) {
        MessageBusProducerLogEvent event = cache.get();
        cache.remove();
        try {
            PubResponse response = (PubResponse)result;
            if (response.getSuccess().booleanValue()) {
                event.setMessageId(response.getMessageId());
            } else {
                event.setSuccessful(false);
                event.setMessage(response.getError());
            }
        }
        catch (Throwable throwable) {
            event.setMessage("[After]\u6536\u96c6MessageBusProducer\u65e5\u5fd7\u6570\u636e\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)throwable));
        }
        this.logSender.send((LogEvent)event);
    }

    public void onException(Throwable ex) {
        MessageBusProducerLogEvent event = cache.get();
        cache.remove();
        event.setThrowable(ex);
        this.logSender.send((LogEvent)event);
    }
}

