package com.xforceplus.xlog.messagebus;

import com.xforceplus.xlog.core.model.MethodEventListener;
import com.xforceplus.xlog.core.model.impl.MessageBusProducerLogEvent;
import com.xforceplus.xlog.core.utils.JavassistUtil;
import lombok.extern.slf4j.Slf4j;

/**
 * 消息总线准备
 *
 * @author gulei
 * @date 2023/01/19
 */
@Slf4j
public class MessageBusPreparing {
    private MessageBusPreparing() {
        throw new IllegalStateException("Utility class");
    }

    /**
     * 准备
     */
    public static void prepare() {
        final String mbClientClassName = "com.xforceplus.janus.message.sdk.MBClient";
        final String mbClientMethodName = "pub";

        try {
            JavassistUtil.installEventListener(mbClientClassName, mbClientMethodName, MethodEventListener.class, MessageBusProducerLogEvent.class);

            log.info(String.format("%s.%s 已完成字节码变更处理并载入到ClassLoader中...", mbClientClassName, mbClientMethodName));
        } catch (Throwable e) {
            log.error(String.format("%s.%s 字节码变更失败...", mbClientClassName, mbClientMethodName), e);
        }
    }
}
