/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.messagebus.model.impl;

import com.alibaba.fastjson.JSON;
import com.xforceplus.janus.message.sdk.RequestMessage;
import com.xforceplus.janus.message.sdk.request.PubRequest;
import com.xforceplus.janus.message.sdk.response.PubResponse;
import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.LogEvent;
import com.xforceplus.xlog.core.model.MethodEventListener;
import com.xforceplus.xlog.core.model.impl.MessageBusProducerLogEvent;
import com.xforceplus.xlog.core.utils.ExceptionUtil;
import com.xforceplus.xlog.logsender.model.LogSender;
import java.nio.charset.StandardCharsets;

public class MessageBusProducerListenerImpl
extends MethodEventListener {
    private final LogSender logSender;
    private final String storeName;

    public MessageBusProducerListenerImpl(LogSender logSender, String storeName) {
        this.logSender = logSender;
        this.storeName = storeName;
    }

    public void beforeCall(Object target, LogEvent logEvent, Object[] args) {
        if (!(logEvent instanceof MessageBusProducerLogEvent)) {
            return;
        }
        MessageBusProducerLogEvent event = (MessageBusProducerLogEvent)logEvent;
        String traceId = LogContext.getTraceId();
        event.setStoreName(this.storeName);
        event.setTraceId(traceId);
        event.setParentTraceId(LogContext.getParentTraceId());
        event.setTenantInfo(LogContext.getTenantInfo());
        try {
            PubRequest pubRequest = (PubRequest)args[0];
            event.setName(pubRequest.getPubCode());
            RequestMessage requestMessage = pubRequest.getRequestMessage();
            String messageText = requestMessage.getContent();
            event.setMessageText(messageText);
            event.setMessageTextSize(messageText.getBytes(StandardCharsets.UTF_8).length);
            event.setBusinessNo((String)requestMessage.getProperties().get("businessNo"));
            event.setMessageProperties(JSON.toJSONString((Object)requestMessage.getProperties()));
        }
        catch (Throwable throwable) {
            event.setWarnMessage("[Before]\u6536\u96c6MessageBusProducer\u65e5\u5fd7\u6570\u636e\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)throwable));
        }
    }

    public Object afterCall(Object target, LogEvent logEvent, Object[] args, Object result) {
        if (!(logEvent instanceof MessageBusProducerLogEvent)) {
            return result;
        }
        MessageBusProducerLogEvent event = (MessageBusProducerLogEvent)logEvent;
        try {
            PubResponse response = (PubResponse)result;
            if (response.getSuccess().booleanValue()) {
                event.setMessageId(response.getMessageId());
            } else {
                event.setSuccessful(false);
                event.setWarnMessage(response.getError());
            }
        }
        catch (Throwable throwable) {
            event.setWarnMessage("[After]\u6536\u96c6MessageBusProducer\u65e5\u5fd7\u6570\u636e\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)throwable));
        }
        this.logSender.send((LogEvent)event);
        return result;
    }

    public void onException(Object target, LogEvent logEvent, Throwable ex) {
        if (!(logEvent instanceof MessageBusProducerLogEvent)) {
            return;
        }
        MessageBusProducerLogEvent event = (MessageBusProducerLogEvent)logEvent;
        event.setThrowable(ex);
        this.logSender.send((LogEvent)event);
    }
}

