/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.messagebus.model.impl;

import com.alibaba.fastjson.JSON;
import com.xforceplus.janus.message.sdk.ResponseMessage;
import com.xforceplus.phoenix.messagebus.model.MessageBusConsumerInterceptor;
import com.xforceplus.phoenix.messagebus.model.MessageConsumerExecution;
import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.LogEvent;
import com.xforceplus.xlog.core.model.impl.MessageBusConsumerLogEvent;
import com.xforceplus.xlog.core.utils.ExceptionUtil;
import com.xforceplus.xlog.logsender.model.LogSender;
import java.nio.charset.StandardCharsets;

public class MessageBusConsumerInterceptorImpl
implements MessageBusConsumerInterceptor {
    private final String storeName;
    private final LogSender logSender;

    public MessageBusConsumerInterceptorImpl(LogSender logSender, String storeName) {
        this.storeName = storeName;
        this.logSender = logSender;
    }

    public Object intercept(ResponseMessage responseMessage, MessageConsumerExecution execution) {
        LogContext.init();
        MessageBusConsumerLogEvent event = new MessageBusConsumerLogEvent();
        event.setTraceId(LogContext.getTraceId());
        event.setMessageId(responseMessage.getId() + "");
        event.setName(responseMessage.getPubCode());
        event.setStoreName(this.storeName);
        event.setReconsumeTimes(responseMessage.getConsumeTimes() - 1);
        event.setPubAppKey(responseMessage.getPubAppKey());
        this.beforeExecute(event, responseMessage);
        try {
            Object object = execution.execute(responseMessage);
            return object;
        }
        catch (Throwable throwable) {
            event.setThrowable(throwable);
            throw throwable;
        }
        finally {
            event.fetchContext();
            this.logSender.send((LogEvent)event);
            LogContext.clear();
        }
    }

    private void beforeExecute(MessageBusConsumerLogEvent event, ResponseMessage responseMessage) {
        try {
            event.setMessageText(responseMessage.getContent());
            event.setMessageTextSize(responseMessage.getContent().getBytes(StandardCharsets.UTF_8).length);
            event.setMessageProperties(JSON.toJSONString((Object)responseMessage.getProperties()));
        }
        catch (Throwable throwable) {
            event.setWarnMessage("\u6536\u96c6MessageBusConsumer\u65e5\u5fd7\u6570\u636e\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)throwable));
        }
    }
}

