/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.mybatis;

import com.alibaba.fastjson.JSON;
import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.LogEvent;
import com.xforceplus.xlog.core.model.impl.MyBatisLogEvent;
import com.xforceplus.xlog.core.utils.ExceptionUtil;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.mybatis.sqlpretty.SqlPrettyUtil;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class XlogMyBatisExecutorInterceptor
implements Interceptor {
    private final String storeName;
    private final LogSender logSender;
    private final boolean sqlEnabled;
    private final boolean sqlResultEnabled;

    public XlogMyBatisExecutorInterceptor(String storeName, LogSender logSender, boolean sqlEnabled, boolean sqlResultEnabled) {
        this.storeName = storeName;
        this.logSender = logSender;
        this.sqlEnabled = sqlEnabled;
        this.sqlResultEnabled = sqlResultEnabled;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object result;
        MyBatisLogEvent event = new MyBatisLogEvent();
        event.setStoreName(this.storeName);
        event.setTraceId(LogContext.getTraceId());
        event.setType("MyBatis");
        this.beforeExecute(event, invocation);
        try {
            result = invocation.proceed();
        }
        catch (Throwable throwable) {
            event.setThrowable(throwable);
            this.logSender.send((LogEvent)event);
            throw throwable;
        }
        this.afterExecute(event, invocation, result);
        this.logSender.send((LogEvent)event);
        return result;
    }

    public Object plugin(Object o) {
        if (o instanceof Executor) {
            return Plugin.wrap((Object)o, (Interceptor)this);
        }
        return o;
    }

    public void setProperties(Properties properties) {
    }

    private void beforeExecute(MyBatisLogEvent event, Invocation invocation) {
        try {
            Object[] args = invocation.getArgs();
            MappedStatement mappedStatement = (MappedStatement)args[0];
            Object parameterObject = args[1];
            event.setName(mappedStatement.getId());
            event.setResourceFile(mappedStatement.getResource());
            event.setSqlCommandType(mappedStatement.getSqlCommandType().name());
            if (this.sqlEnabled) {
                event.setSql(SqlPrettyUtil.prettify(mappedStatement, parameterObject));
                event.setSqlSize(event.getSql().getBytes(StandardCharsets.UTF_8).length);
            }
        }
        catch (Throwable throwable) {
            event.setMessage("(\u524d)MyBatisExecutor\u57cb\u70b9\u6570\u636e\u6536\u96c6\u53d1\u751f\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)throwable));
        }
    }

    private void afterExecute(MyBatisLogEvent event, Invocation invocation, Object result) {
        try {
            if (this.sqlResultEnabled) {
                event.setSqlResult(JSON.toJSONString((Object)result));
                event.setSqlResultSize(event.getSqlResult().getBytes(StandardCharsets.UTF_8).length);
            }
        }
        catch (Throwable throwable) {
            event.setMessage("(\u540e)MyBatisExecutor\u57cb\u70b9\u6570\u636e\u6536\u96c6\u53d1\u751f\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)throwable));
        }
    }
}

