/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.mybatis.sqlpretty;

import com.alibaba.fastjson.JSON;
import com.xforceplus.xlog.core.exception.XlogException;
import com.xforceplus.xlog.core.utils.ExceptionUtil;
import com.xforceplus.xlog.mybatis.sqlpretty.DefaultMemberAccess;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.ognl.ClassResolver;
import org.apache.ibatis.ognl.DefaultClassResolver;
import org.apache.ibatis.ognl.DefaultTypeConverter;
import org.apache.ibatis.ognl.MemberAccess;
import org.apache.ibatis.ognl.Ognl;
import org.apache.ibatis.ognl.OgnlContext;
import org.apache.ibatis.ognl.TypeConverter;

public class SqlPrettyUtil {
    public static String prettify(MappedStatement mappedStatement, Object parameterObject) {
        BoundSql boundSql = mappedStatement.getBoundSql(parameterObject);
        List parameterMappingList = boundSql.getParameterMappings();
        Class<?> parameterClazz = parameterObject.getClass();
        String sql = boundSql.getSql().replaceAll("\\s+", " ");
        if ("net.coderbee.mybatis.batch.BatchParameter".equals(parameterClazz.getName())) {
            return SqlPrettyUtil.processCoderBeeBatchPlugin(sql, parameterObject);
        }
        for (ParameterMapping parameterMapping : parameterMappingList) {
            Class javaType = parameterMapping.getJavaType();
            String property = parameterMapping.getProperty();
            int index = SqlPrettyUtil.findFirstRealQuestionMark(sql);
            if (index == -1) {
                throw XlogException.create((String)"findFirstRealQuestionMark \u7d22\u5f15\u503c\u4e3a-1");
            }
            try {
                if (parameterClazz == javaType) {
                    sql = SqlPrettyUtil.replaceAtIndex(sql, index, SqlPrettyUtil.handleType(parameterObject));
                    continue;
                }
                if (boundSql.hasAdditionalParameter(property)) {
                    sql = SqlPrettyUtil.replaceAtIndex(sql, index, SqlPrettyUtil.handleType(boundSql.getAdditionalParameter(property)));
                    continue;
                }
                OgnlContext context = new OgnlContext((ClassResolver)new DefaultClassResolver(), (TypeConverter)new DefaultTypeConverter(), (MemberAccess)new DefaultMemberAccess(true));
                sql = SqlPrettyUtil.replaceAtIndex(sql, index, SqlPrettyUtil.handleType(Ognl.getValue((String)property, (Map)context, (Object)parameterObject)));
            }
            catch (Throwable e) {
                sql = SqlPrettyUtil.replaceAtIndex(sql, index, String.format("<\u6b64\u5904\u5f02\u5e38\uff0c\u9ebb\u70e6\u627e\u987e\u78ca\u770b\u4e0b\uff0c%s>", ExceptionUtil.toDesc((Throwable)e)));
            }
        }
        return sql;
    }

    private static String processCoderBeeBatchPlugin(String sql, Object parameterObject) {
        StringBuilder sb = new StringBuilder();
        sb.append("<CoderBee MyBatis Batch Plugin>").append("\n\n").append(sql).append("\n\n").append(JSON.toJSONString((Object)parameterObject));
        return sb.toString();
    }

    private static int findFirstRealQuestionMark(String sql) {
        boolean quoteFlag = false;
        for (int i = 0; i < sql.length(); ++i) {
            char ch = sql.charAt(i);
            if (ch == '\'') {
                boolean bl = quoteFlag = !quoteFlag;
            }
            if (ch != '?' || quoteFlag) continue;
            return i;
        }
        return -1;
    }

    private static String replaceAtIndex(String text, int index, String replacement) {
        return text.substring(0, index) + replacement + text.substring(index + 1);
    }

    private static String handleType(Object data) {
        Class<?> clazz = data.getClass();
        if (clazz == String.class) {
            return String.format("'%s'", data);
        }
        if (clazz == Date.class) {
            return String.format("'%s'", DateFormatUtils.format((Date)((Date)data), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (clazz == BigDecimal.class) {
            return String.format("%s", ((BigDecimal)data).toPlainString());
        }
        return data + "";
    }
}

