/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.mybatis;

import com.alibaba.fastjson.JSON;
import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.LogEvent;
import com.xforceplus.xlog.core.model.impl.MyBatisLogEvent;
import com.xforceplus.xlog.core.model.setting.XlogMyBatisSettings;
import com.xforceplus.xlog.core.utils.ExceptionUtil;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.mybatis.model.SqlPrettyResult;
import com.xforceplus.xlog.mybatis.sqlpretty.SqlPrettyUtil;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class XlogMyBatisExecutorInterceptor
implements Interceptor {
    private final String storeName;
    private final LogSender logSender;
    private final boolean sqlEnabled;
    private final boolean sqlResultEnabled;
    private final XlogMyBatisSettings settings;

    public XlogMyBatisExecutorInterceptor(String storeName, LogSender logSender, boolean sqlEnabled, boolean sqlResultEnabled, XlogMyBatisSettings myBatisSettings) {
        this.storeName = storeName;
        this.logSender = logSender;
        this.sqlEnabled = sqlEnabled;
        this.sqlResultEnabled = sqlResultEnabled;
        this.settings = myBatisSettings;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object result;
        Boolean enabledSetting = Optional.ofNullable(this.settings).map(XlogMyBatisSettings::getEnabled).orElse(null);
        if (enabledSetting != null && !enabledSetting.booleanValue()) {
            return invocation.proceed();
        }
        MyBatisLogEvent event = new MyBatisLogEvent();
        event.setStoreName(this.storeName);
        event.setTraceId(LogContext.getTraceId());
        event.setParentTraceId(LogContext.getParentTraceId());
        event.setTenantInfo(LogContext.getTenantInfo());
        this.beforeExecute(event, invocation);
        try {
            result = invocation.proceed();
        }
        catch (Throwable throwable) {
            event.setThrowable(throwable);
            this.logSender.send((LogEvent)event);
            throw throwable;
        }
        this.afterExecute(event, invocation, result);
        this.logSender.send((LogEvent)event);
        return result;
    }

    public Object plugin(Object o) {
        if (o instanceof Executor) {
            return Plugin.wrap((Object)o, (Interceptor)this);
        }
        return o;
    }

    public void setProperties(Properties properties) {
    }

    private void beforeExecute(MyBatisLogEvent event, Invocation invocation) {
        try {
            Object[] args = invocation.getArgs();
            MappedStatement mappedStatement = (MappedStatement)args[0];
            Object parameterObject = args[1];
            event.setName(mappedStatement.getId());
            event.setResourceFile(mappedStatement.getResource());
            event.setSqlCommandType(mappedStatement.getSqlCommandType().name());
            try {
                SqlPrettyResult sqlPrettyResult = SqlPrettyUtil.prettify(mappedStatement, parameterObject);
                event.setTables(StringUtils.join(sqlPrettyResult.getTables(), (String)" "));
                event.setPlugins(StringUtils.join(sqlPrettyResult.getPlugins(), (String)" "));
                event.setWhereColumns(StringUtils.join(sqlPrettyResult.getColumns(), (String)" "));
                Boolean sqlEnabledSetting = Optional.ofNullable(this.settings).map(XlogMyBatisSettings::getSqlEnabled).orElse(null);
                if (sqlEnabledSetting != null && sqlEnabledSetting.booleanValue() || sqlEnabledSetting == null && this.sqlEnabled) {
                    event.setSql(sqlPrettyResult.getSql());
                    event.setParameters(sqlPrettyResult.getParameters());
                    event.setSqlSize(event.getSql().getBytes(StandardCharsets.UTF_8).length);
                }
            }
            catch (Throwable throwable) {
                event.setWarnMessage("(\u524d)MyBatisExecutor\u57cb\u70b9\u6570\u636e\u89e3\u6790SQL\u53d1\u751f\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)throwable));
                event.setSql(mappedStatement.getBoundSql(parameterObject).getSql());
                event.setSqlSize(event.getSql().getBytes(StandardCharsets.UTF_8).length);
            }
        }
        catch (Throwable throwable) {
            event.setWarnMessage("(\u524d)MyBatisExecutor\u57cb\u70b9\u6570\u636e\u6536\u96c6\u53d1\u751f\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)throwable));
        }
    }

    private void afterExecute(MyBatisLogEvent event, Invocation invocation, Object result) {
        try {
            Boolean sqlResultEnabledSetting = Optional.ofNullable(this.settings).map(XlogMyBatisSettings::getSqlResultEnabled).orElse(null);
            if (sqlResultEnabledSetting != null && sqlResultEnabledSetting.booleanValue() || sqlResultEnabledSetting == null && this.sqlResultEnabled) {
                event.setSqlResult(JSON.toJSONString((Object)result));
                event.setSqlResultSize(event.getSqlResult().getBytes(StandardCharsets.UTF_8).length);
            }
        }
        catch (Throwable throwable) {
            event.setWarnMessage("(\u540e)MyBatisExecutor\u57cb\u70b9\u6570\u636e\u6536\u96c6\u53d1\u751f\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)throwable));
        }
    }
}

