/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.mybatis.sqlpretty;

import com.alibaba.fastjson.JSON;
import com.xforceplus.xlog.core.exception.XlogException;
import com.xforceplus.xlog.core.utils.ExceptionUtil;
import com.xforceplus.xlog.mybatis.model.SqlPrettyResult;
import com.xforceplus.xlog.mybatis.sqlpretty.DefaultMemberAccess;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.ognl.ClassResolver;
import org.apache.ibatis.ognl.DefaultClassResolver;
import org.apache.ibatis.ognl.DefaultTypeConverter;
import org.apache.ibatis.ognl.MemberAccess;
import org.apache.ibatis.ognl.Ognl;
import org.apache.ibatis.ognl.OgnlContext;
import org.apache.ibatis.ognl.TypeConverter;

public class SqlPrettyUtil {
    private SqlPrettyUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static SqlPrettyResult prettify(MappedStatement mappedStatement, Object parameterObject) {
        SqlPrettyResult result = new SqlPrettyResult();
        BoundSql boundSql = mappedStatement.getBoundSql(parameterObject);
        List parameterMappingList = boundSql.getParameterMappings();
        Class<?> parameterClazz = parameterObject.getClass();
        String sql = boundSql.getSql().replaceAll("\\s+", " ");
        result.setSql(sql);
        if (SqlPrettyUtil.isCoderBeeBatchPlugin(parameterClazz.getName())) {
            result.setParameters(JSON.toJSONString((Object)parameterObject));
            result.getPlugins().add("net.coderbee.mybatis.batch");
            return result;
        }
        for (ParameterMapping parameterMapping : parameterMappingList) {
            Class javaType = parameterMapping.getJavaType();
            String property = parameterMapping.getProperty();
            int index = SqlPrettyUtil.findFirstRealQuestionMark(sql);
            if (index == -1) {
                throw XlogException.create((String)"findFirstRealQuestionMark \u7d22\u5f15\u503c\u4e3a-1");
            }
            try {
                if (parameterClazz == javaType) {
                    sql = SqlPrettyUtil.replaceAtIndex(sql, index, SqlPrettyUtil.handleType(parameterObject));
                    continue;
                }
                if (boundSql.hasAdditionalParameter(property)) {
                    sql = SqlPrettyUtil.replaceAtIndex(sql, index, SqlPrettyUtil.handleType(boundSql.getAdditionalParameter(property)));
                    continue;
                }
                OgnlContext context = new OgnlContext((ClassResolver)new DefaultClassResolver(), (TypeConverter)new DefaultTypeConverter(), (MemberAccess)new DefaultMemberAccess(true));
                sql = SqlPrettyUtil.replaceAtIndex(sql, index, SqlPrettyUtil.handleType(Ognl.getValue((String)property, (Map)context, (Object)parameterObject)));
            }
            catch (Throwable e) {
                throw new RuntimeException("PrettySQL Exception: " + ExceptionUtil.toDesc((Throwable)e));
            }
        }
        result.setSql(sql);
        return result;
    }

    private static boolean isCoderBeeBatchPlugin(String className) {
        return "net.coderbee.mybatis.batch.BatchParameter".equals(className);
    }

    private static int findFirstRealQuestionMark(String sql) {
        boolean quoteFlag = false;
        for (int i = 0; i < sql.length(); ++i) {
            char ch = sql.charAt(i);
            if (ch == '\'') {
                boolean bl = quoteFlag = !quoteFlag;
            }
            if (ch != '?' || quoteFlag) continue;
            return i;
        }
        return -1;
    }

    private static String replaceAtIndex(String text, int index, String replacement) {
        return text.substring(0, index) + replacement + text.substring(index + 1);
    }

    private static String handleType(Object data) {
        if (data == null) {
            return "NULL";
        }
        Class<?> clazz = data.getClass();
        if (clazz == String.class) {
            return String.format("'%s'", data);
        }
        if (clazz == Date.class) {
            return String.format("'%s'", DateFormatUtils.format((Date)((Date)data), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (clazz == BigDecimal.class) {
            return String.format("%s", ((BigDecimal)data).toPlainString());
        }
        return data + "";
    }
}

