package com.xforceplus.xlog.mybatis.sqlpretty;

import org.apache.ibatis.ognl.MemberAccess;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Map;

/**
 * 默认的方法访问器
 * <p>
 * 为了解决高版本OGNL的变化，在高版本中，这个类不再默认提供
 *
 * @author gulei
 * @date 2023/01/19
 */
public class DefaultMemberAccess implements MemberAccess {
    public boolean allowPrivateAccess;
    public boolean allowProtectedAccess;
    public boolean allowPackageProtectedAccess;

    /**
     * 构造函数
     *
     * @param allowAllAccess 是否允许所有的访问
     */
    public DefaultMemberAccess(boolean allowAllAccess) {
        this(allowAllAccess, allowAllAccess, allowAllAccess);
    }

    /**
     * 构造函数
     *
     * @param allowPrivateAccess          是否允许私有访问
     * @param allowProtectedAccess        是否允许保护访问
     * @param allowPackageProtectedAccess 是否运行包级保护访问
     */
    public DefaultMemberAccess(boolean allowPrivateAccess, boolean allowProtectedAccess, boolean allowPackageProtectedAccess) {
        this.allowPrivateAccess = false;
        this.allowProtectedAccess = false;
        this.allowPackageProtectedAccess = false;
        this.allowPrivateAccess = allowPrivateAccess;
        this.allowProtectedAccess = allowProtectedAccess;
        this.allowPackageProtectedAccess = allowPackageProtectedAccess;
    }

    /**
     * 获取是否允许私有访问
     *
     * @return 是否允许私有访问
     */
    public boolean getAllowPrivateAccess() {
        return this.allowPrivateAccess;
    }

    /**
     * setAllowPrivateAccess
     *
     * @param value value
     */
    public void setAllowPrivateAccess(boolean value) {
        this.allowPrivateAccess = value;
    }

    /**
     * getAllowProtectedAccess
     *
     * @return boolean
     */
    public boolean getAllowProtectedAccess() {
        return this.allowProtectedAccess;
    }

    /**
     * setAllowProtectedAccess
     *
     * @param value value
     */
    public void setAllowProtectedAccess(boolean value) {
        this.allowProtectedAccess = value;
    }

    /**
     * getAllowPackageProtectedAccess
     *
     * @return boolean
     */
    public boolean getAllowPackageProtectedAccess() {
        return this.allowPackageProtectedAccess;
    }

    /**
     * setAllowPackageProtectedAccess
     *
     * @param value value
     */
    public void setAllowPackageProtectedAccess(boolean value) {
        this.allowPackageProtectedAccess = value;
    }

    /**
     * setup
     *
     * @param context      context
     * @param target       target
     * @param member       member
     * @param propertyName propertyName
     * @return Object
     */
    public Object setup(Map context, Object target, Member member, String propertyName) {
        Object result = null;
        if (this.isAccessible(context, target, member, propertyName)) {
            final AccessibleObject accessible = (AccessibleObject) member;
            if (!accessible.isAccessible()) {
                result = Boolean.TRUE;
                accessible.setAccessible(true);
            }
        }

        return result;
    }

    /**
     * 还原
     *
     * @param context      context
     * @param target       target
     * @param member       member
     * @param propertyName propertyName
     * @param state        state
     */
    public void restore(Map context, Object target, Member member, String propertyName, Object state) {
        if (state != null) {
            ((AccessibleObject) member).setAccessible((Boolean) state);
        }

    }

    /**
     * isAccessible
     *
     * @param context      context
     * @param target       target
     * @param member       member
     * @param propertyName propertyName
     * @return boolean
     */
    public boolean isAccessible(Map context, Object target, Member member, String propertyName) {
        final int modifiers = member.getModifiers();
        boolean result = Modifier.isPublic(modifiers);
        if (!result) {
            if (Modifier.isPrivate(modifiers)) {
                result = this.getAllowPrivateAccess();
            } else if (Modifier.isProtected(modifiers)) {
                result = this.getAllowProtectedAccess();
            } else {
                result = this.getAllowPackageProtectedAccess();
            }
        }

        return result;
    }
}
