/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.okhttp;

import com.xforceplus.xlog.core.model.MethodEventListener;
import com.xforceplus.xlog.core.model.impl.RpcLogEvent;
import com.xforceplus.xlog.core.utils.JavassistUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlogOkHttpPreparing {
    private static final Logger log = LoggerFactory.getLogger(XlogOkHttpPreparing.class);

    public static void prepare() {
        XlogOkHttpPreparing.prepareForOkHttp("okhttp3.RealCall");
        XlogOkHttpPreparing.prepareForOkHttp("okhttp3.internal.connection.RealCall");
    }

    public static void prepareForOkHttp(String mbClientClassName) {
        String mbClientMethodName = "execute";
        try {
            boolean result = JavassistUtil.installEventListener((String)mbClientClassName, (String)"execute", MethodEventListener.class, RpcLogEvent.class);
            if (result) {
                log.info(String.format("%s.%s \u5df2\u5b8c\u6210\u5b57\u8282\u7801\u53d8\u66f4\u5904\u7406\u5e76\u8f7d\u5165\u5230ClassLoader\u4e2d...", mbClientClassName, "execute"));
            }
        }
        catch (Throwable e) {
            log.error(String.format("%s.%s \u5b57\u8282\u7801\u53d8\u66f4\u5931\u8d25...", mbClientClassName, "execute"), e);
        }
    }
}

