/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.okhttp.model.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xforceplus.xlog.core.constant.RpcUserAgent;
import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.LogEvent;
import com.xforceplus.xlog.core.model.MethodEventListener;
import com.xforceplus.xlog.core.model.StandardResponseDTO;
import com.xforceplus.xlog.core.model.impl.RpcLogEvent;
import com.xforceplus.xlog.core.model.setting.XlogRpcSettings;
import com.xforceplus.xlog.core.utils.ExceptionUtil;
import com.xforceplus.xlog.logsender.model.LogSender;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlogOkHttpRealCallListener
extends MethodEventListener {
    private static final Logger log = LoggerFactory.getLogger(XlogOkHttpRealCallListener.class);
    private static final Set<String> fileContentType = Sets.newHashSet((Object[])new String[]{"application/pdf", "image/jpeg", "image/jpg", "application/octet-stream", "image/png"});
    private final LogSender logSender;
    private final String storeName;
    private final XlogRpcSettings xlogRpcSettings;
    private final RpcUserAgent agent;
    private Method requestMethod;
    private boolean errorFlag;

    public XlogOkHttpRealCallListener(LogSender logSender, String storeName, @Nullable XlogRpcSettings xlogRpcSettings, RpcUserAgent agent) {
        this.logSender = logSender;
        this.storeName = storeName;
        this.xlogRpcSettings = xlogRpcSettings;
        this.agent = agent;
    }

    public void beforeCall(Object target, LogEvent logEvent, Object[] args) {
        block19: {
            if (!(logEvent instanceof RpcLogEvent)) {
                return;
            }
            Request originalRequest = this.getRequest(target);
            if (originalRequest == null) {
                return;
            }
            RpcLogEvent event = (RpcLogEvent)logEvent;
            String traceId = LogContext.getTraceId();
            event.setStoreName(this.storeName);
            event.setTraceId(traceId);
            event.setParentTraceId(LogContext.getParentTraceId());
            event.setUserAgent(this.agent.toName());
            event.setTenantInfo(LogContext.getTenantInfo());
            if (this.xlogRpcSettings != null) {
                event.setLimitSize(this.xlogRpcSettings.getLimitSize());
            }
            try {
                event.setMethod(originalRequest.method());
                event.setUrl(originalRequest.url().url().toString());
                event.setName(originalRequest.url().uri().getPath());
                event.setHeaders(this.headers2String(originalRequest.headers()));
                ArrayList hasBodyMethods = Lists.newArrayList((Object[])new String[]{"POST", "PUT", "PATCH"});
                if (originalRequest.body() == null || !hasBodyMethods.contains(originalRequest.method())) break block19;
                try (Buffer buffer = new Buffer();){
                    originalRequest.body().writeTo((BufferedSink)buffer);
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    buffer.writeTo((OutputStream)bos);
                    byte[] data = bos.toByteArray();
                    event.setRequestText(new String(data, StandardCharsets.UTF_8));
                    event.setRequestSize(data.length);
                }
                catch (Throwable ex) {
                    event.setWarnMessage(String.format("\u8bfb\u53d6OkHttpRequest Body\u65f6\u5f02\u5e38\uff01%s", ExceptionUtil.toDesc((Throwable)ex)));
                }
            }
            catch (Throwable ex) {
                event.setWarnMessage(String.format("[Before]\u6536\u96c6OkHttp\u65e5\u5fd7\u6570\u636e\u5f02\u5e38: %s", ExceptionUtil.toDesc((Throwable)ex)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object afterCall(Object target, LogEvent logEvent, Object[] args, Object result) {
        if (!(logEvent instanceof RpcLogEvent)) {
            return result;
        }
        RpcLogEvent event = (RpcLogEvent)logEvent;
        if (!(result instanceof Response)) {
            return result;
        }
        Response response = (Response)result;
        try {
            Response response2;
            Object object;
            ResponseBody responseBody;
            block49: {
                block50: {
                    byte[] data;
                    MediaType responseContentType;
                    block46: {
                        block47: {
                            block48: {
                                block43: {
                                    block44: {
                                        block45: {
                                            block42: {
                                                block39: {
                                                    Object object2;
                                                    block40: {
                                                        block41: {
                                                            responseBody = response.body();
                                                            object = null;
                                                            if (responseBody != null) break block39;
                                                            object2 = result;
                                                            if (responseBody == null) break block40;
                                                            if (object == null) break block41;
                                                            try {
                                                                responseBody.close();
                                                            }
                                                            catch (Throwable throwable) {
                                                                ((Throwable)object).addSuppressed(throwable);
                                                            }
                                                            break block40;
                                                        }
                                                        responseBody.close();
                                                    }
                                                    return object2;
                                                }
                                                Headers responseHeaders = response.headers();
                                                responseContentType = responseBody.contentType();
                                                event.setHttpStatus(String.format("%d %s", response.code(), response.message()));
                                                event.setResponseHeader(this.headers2String(responseHeaders));
                                                if (responseContentType != null) {
                                                    event.setContentType(responseContentType.toString());
                                                }
                                                data = responseBody.bytes();
                                                event.setResponseSize(data.length);
                                                try {
                                                    if (responseContentType != null && fileContentType.stream().anyMatch(t -> responseContentType.toString().contains((CharSequence)t))) {
                                                        event.setResponseText(null);
                                                        break block42;
                                                    }
                                                    String responseText = new String(data, StandardCharsets.UTF_8);
                                                    event.setResponseText(responseText);
                                                    try {
                                                        StandardResponseDTO standardResponseDTO = (StandardResponseDTO)JSON.parseObject((String)responseText, StandardResponseDTO.class);
                                                        if (standardResponseDTO != null && StringUtils.isNotBlank((CharSequence)standardResponseDTO.getCode()) && this.xlogRpcSettings != null && this.xlogRpcSettings.getSuccessfulResponseCodes() != null) {
                                                            event.setSuccessful(this.xlogRpcSettings.getSuccessfulResponseCodes().contains(standardResponseDTO.getCode()));
                                                        }
                                                    }
                                                    catch (JSONException standardResponseDTO) {
                                                    }
                                                    catch (Exception ex) {
                                                        event.setWarnMessage("\u6839\u636eresponseCode\u8bbe\u7f6e\u65e5\u5fd7successful\u5c5e\u6027\u65f6\uff0c\u53d1\u751f\u5f02\u5e38\uff01" + ExceptionUtil.toDesc((Throwable)ex));
                                                        log.warn("\u6839\u636eresponseCode\u8bbe\u7f6e\u65e5\u5fd7successful\u5c5e\u6027\u65f6\uff0c\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)ex);
                                                    }
                                                }
                                                catch (Throwable e) {
                                                    event.setWarnMessage(String.format("\u8bb0\u5f55\u8fd4\u56de\u7ed3\u679c\u65f6\uff0c\u7f16\u7801\u8f6c\u6362\u5f02\u5e38\uff01%s", ExceptionUtil.toDesc((Throwable)e)));
                                                }
                                            }
                                            if (this.agent != RpcUserAgent.OKHTTP3) break block43;
                                            response2 = response.newBuilder().body(ResponseBody.create((MediaType)responseContentType, (byte[])data)).build();
                                            if (responseBody == null) break block44;
                                            if (object == null) break block45;
                                            try {
                                                responseBody.close();
                                            }
                                            catch (Throwable throwable) {
                                                ((Throwable)object).addSuppressed(throwable);
                                            }
                                            break block44;
                                        }
                                        responseBody.close();
                                    }
                                    return response2;
                                }
                                if (this.agent != RpcUserAgent.OKHTTP4) break block46;
                                response2 = response.newBuilder().body(ResponseBody.create((byte[])data, (MediaType)responseContentType)).build();
                                if (responseBody == null) break block47;
                                if (object == null) break block48;
                                try {
                                    responseBody.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                                break block47;
                            }
                            responseBody.close();
                        }
                        return response2;
                    }
                    response2 = response.newBuilder().body(ResponseBody.create((byte[])data, (MediaType)responseContentType)).build();
                    if (responseBody == null) break block49;
                    if (object == null) break block50;
                    try {
                        responseBody.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    break block49;
                }
                responseBody.close();
            }
            return response2;
            catch (Throwable throwable) {
                try {
                    try {
                        object = throwable;
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (responseBody != null) {
                            if (object != null) {
                                try {
                                    responseBody.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)object).addSuppressed(throwable3);
                                }
                            } else {
                                responseBody.close();
                            }
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable ex) {
                    event.setWarnMessage("[After]\u6536\u96c6OkHttp\u65e5\u5fd7\u6570\u636e\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)ex));
                    object = result;
                    return object;
                }
            }
        }
        finally {
            this.logSender.send((LogEvent)event);
        }
    }

    public void onException(Object target, LogEvent logEvent, Throwable ex) {
        if (!(logEvent instanceof RpcLogEvent)) {
            return;
        }
        RpcLogEvent event = (RpcLogEvent)logEvent;
        event.setThrowable(ex);
        this.logSender.send((LogEvent)event);
    }

    public boolean shouldSkip(Object target, Object[] args) {
        Request originalRequest = this.getRequest(target);
        if (originalRequest == null) {
            return false;
        }
        try {
            return this.matches(originalRequest.method(), originalRequest.url().url().toString());
        }
        catch (Throwable throwable) {
            log.warn("[shouldSkip]OkHttp\u5224\u65ad\u662f\u5426\u9700\u8981\u8df3\u8fc7\u65e5\u5fd7\u65f6\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)throwable), throwable);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Request getRequest(Object target) {
        Class<?> realCallClazz = target.getClass();
        if (!"okhttp3.internal.connection.RealCall".equals(realCallClazz.getName()) && !"okhttp3.RealCall".equals(realCallClazz.getName())) {
            return null;
        }
        if (this.errorFlag) {
            return null;
        }
        if (this.requestMethod == null) {
            Class<XlogOkHttpRealCallListener> clazz = XlogOkHttpRealCallListener.class;
            // MONITORENTER : com.xforceplus.xlog.okhttp.model.impl.XlogOkHttpRealCallListener.class
            try {
                this.requestMethod = realCallClazz.getDeclaredMethod("request", new Class[0]);
                this.requestMethod.setAccessible(true);
            }
            catch (Throwable throwable) {
                this.errorFlag = true;
                log.error("xlog okhttp realCallClazz.getDeclaredMethod(\"request\") occurs exception", throwable);
                // MONITOREXIT : clazz
                return null;
            }
        }
        try {
            return (Request)this.requestMethod.invoke(target, new Object[0]);
        }
        catch (Throwable ex) {
            log.error("xlog okhttp requestMethodHandle.invokeExact(target) occurs exception", ex);
            return null;
        }
    }

    private String headers2String(Headers headers) {
        ArrayList result = Lists.newArrayList();
        Set headerNames = headers.names();
        for (String headerName : headerNames) {
            List headerValueList = headers.values(headerName);
            for (String headerValue : headerValueList) {
                result.add(String.format("%s: %s", headerName, headerValue));
            }
        }
        return StringUtils.join((Iterable)result, (String)"\n");
    }

    private boolean matches(String method, String url) {
        if (this.xlogRpcSettings == null || this.xlogRpcSettings.getBlackUrlPattern() == null) {
            return false;
        }
        return this.xlogRpcSettings.getBlackUrlPattern().matches(method, url);
    }
}

