package com.xforceplus.xlog.okhttp;

import com.xforceplus.xlog.core.model.MethodListener;
import com.xforceplus.xlog.core.utils.JavassistUtil;
import lombok.extern.slf4j.Slf4j;

/**
 * OkHttpPreparing
 *
 * @author gulei
 * @date 2023/06/24
 */
@Slf4j
public class XlogOkHttpPreparing {

    /**
     * 准备
     */
    public static void prepare() {
        final String mbClientClassName = "okhttp3.internal.connection.RealCall";
        final String mbClientMethodName = "execute";

        try {
            JavassistUtil.installListener(mbClientClassName, mbClientMethodName, MethodListener.class);

            log.info(String.format("%s.%s 已完成字节码变更处理并载入到ClassLoader中...", mbClientClassName, mbClientMethodName));
        } catch (Throwable e) {
            log.error(String.format("%s.%s 字节码变更失败...", mbClientClassName, mbClientMethodName), e);
        }
    }
}
