package com.xforceplus.xlog.rocketmq;

import com.xforceplus.xlog.core.model.ClassMethodSignature;
import com.xforceplus.xlog.core.model.MethodEventListener;
import com.xforceplus.xlog.core.model.MethodSignature;
import com.xforceplus.xlog.core.model.impl.RocketMqConsumerLogEvent;
import com.xforceplus.xlog.core.model.impl.RocketMqProducerLogEvent;
import com.xforceplus.xlog.core.utils.JavassistUtil;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Modifier;

@Slf4j
public class XlogRocketMqPreparing {

    /**
     * 消费者准备 - 仅并发消费
     */
    public static void prepareConsumer() {
        final String externalClassName = "org.apache.rocketmq.spring.support.DefaultRocketMQListenerContainer";
        final String innerClassName = "org.apache.rocketmq.spring.support.DefaultRocketMQListenerContainer$DefaultMessageListenerConcurrently";
        final String targetMethodName = "consumeMessage";

        final MethodSignature[] methodSignatures = new MethodSignature[]{
            new MethodSignature(targetMethodName, Modifier.PUBLIC, null)
        };

        final ClassMethodSignature[] classMethodSignatures = {
            new ClassMethodSignature(innerClassName, methodSignatures)
        };

        try {
            final boolean result = JavassistUtil.installEventListener(externalClassName, classMethodSignatures, MethodEventListener.class, RocketMqConsumerLogEvent.class);

            if (result) {
                log.info(String.format("%s.%s 已完成字节码变更处理并载入到ClassLoader中...", externalClassName, targetMethodName));
            }
        } catch (Throwable e) {
            log.error(String.format("%s.%s 字节码变更失败...", externalClassName, targetMethodName), e);
        }
    }

    /**
     * 生产者准备
     */
    public static void prepareProducer() {
        final String mbClientClassName = "org.apache.rocketmq.client.impl.producer.DefaultMQProducerImpl";
        final String mbClientMethodName = "sendKernelImpl";

        final MethodSignature[] methodSignatures = new MethodSignature[]{
            new MethodSignature(mbClientMethodName, Modifier.PRIVATE, null)
        };

        try {
            final boolean result = JavassistUtil.installEventListener(mbClientClassName, methodSignatures, MethodEventListener.class, RocketMqProducerLogEvent.class);

            if (result) {
                log.info(String.format("%s.%s 已完成字节码变更处理并载入到ClassLoader中...", mbClientClassName, mbClientMethodName));
            }
        } catch (Throwable e) {
            log.error(String.format("%s.%s 字节码变更失败...", mbClientClassName, mbClientMethodName), e);
        }
    }
}
