/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.rocketmq.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.LogEvent;
import com.xforceplus.xlog.core.model.MethodEventListener;
import com.xforceplus.xlog.core.model.impl.RocketMqConsumerLogEvent;
import com.xforceplus.xlog.core.model.setting.XlogRocketMqConsumerSettings;
import com.xforceplus.xlog.core.utils.ExceptionUtil;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xfrcpls.xcomponent.xrmq.domain.model.BaseRmqMessage;
import com.xfrcpls.xcomponent.xrmq.domain.model.DelayLevel;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.spring.support.DefaultRocketMQListenerContainer;
import org.apache.rocketmq.spring.support.ExceptionContext;

public class XlogRocketMqConsumerListenerImpl
extends MethodEventListener {
    private final LogSender logSender;
    private final String storeName;
    private final XlogRocketMqConsumerSettings xlogRocketMqConsumerSettings;

    public XlogRocketMqConsumerListenerImpl(LogSender logSender, String storeName, XlogRocketMqConsumerSettings xlogRocketMqConsumerSettings) {
        this.logSender = logSender;
        this.storeName = storeName;
        this.xlogRocketMqConsumerSettings = xlogRocketMqConsumerSettings;
    }

    public void beforeCall(Object target, LogEvent logEvent, Object[] args) {
        if (!(logEvent instanceof RocketMqConsumerLogEvent)) {
            return;
        }
        LogContext.init();
        RocketMqConsumerLogEvent event = (RocketMqConsumerLogEvent)logEvent;
        try {
            MessageExt message = (MessageExt)((List)args[0]).get(0);
            event.setTraceId(LogContext.getTraceId());
            event.setParentTraceId(LogContext.getParentTraceId());
            event.setStoreName(this.storeName);
            event.setTenantInfo(LogContext.getTenantInfo());
            int delayTimeLevel = message.getDelayTimeLevel();
            BaseRmqMessage baseRmqMessage = (BaseRmqMessage)JSON.parseObject((byte[])message.getBody(), BaseRmqMessage.class, (Feature[])new Feature[0]);
            Map properties = baseRmqMessage.getProperties();
            event.setName(message.getTopic());
            event.setTags(message.getTags());
            event.setKeys(message.getKeys());
            event.setMessageProperties(JSON.toJSONString((Object)properties));
            if (delayTimeLevel < DelayLevel.NAMES.length && delayTimeLevel >= 0) {
                event.setDelayLevel(String.format("%s[%d]", DelayLevel.NAMES[delayTimeLevel], delayTimeLevel));
            }
            event.setReconsumeTimes(message.getReconsumeTimes());
            event.setMessageId(message.getMsgId());
            event.setConsumeQueue(String.format("%s[%d]", message.getBrokerName(), message.getQueueId()));
            event.setMessageText(baseRmqMessage.getBody());
            if (baseRmqMessage.getBody().length() <= 0x100000) {
                event.setMessageTextSize(baseRmqMessage.getBody().getBytes(StandardCharsets.UTF_8).length);
            } else {
                event.setMessageTextSize(baseRmqMessage.getBody().length());
            }
        }
        catch (Throwable throwable) {
            event.setWarnMessage("[Before]\u6536\u96c6RocketMqConsumer\u65e5\u5fd7\u6570\u636e\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)throwable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object afterCall(Object target, LogEvent logEvent, Object[] args, Object result) {
        if (!(logEvent instanceof RocketMqConsumerLogEvent)) {
            return result;
        }
        RocketMqConsumerLogEvent event = (RocketMqConsumerLogEvent)logEvent;
        try {
            ConsumeConcurrentlyStatus theResult = (ConsumeConcurrentlyStatus)result;
            event.setConsumeStatus(theResult.name());
            if (theResult != ConsumeConcurrentlyStatus.CONSUME_SUCCESS) {
                event.setSuccessful(false);
                event.setThrowable(ExceptionContext.getException());
            }
        }
        catch (Throwable throwable) {
            event.setWarnMessage("[After]\u6536\u96c6RocketMqConsumer\u65e5\u5fd7\u6570\u636e\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)throwable));
        }
        finally {
            event.fetchContext();
            this.logSender.send((LogEvent)event);
            LogContext.clear();
        }
        return result;
    }

    public void onException(Object target, LogEvent logEvent, Throwable ex) {
        if (!(logEvent instanceof RocketMqConsumerLogEvent)) {
            return;
        }
        RocketMqConsumerLogEvent event = (RocketMqConsumerLogEvent)logEvent;
        event.setThrowable(ex);
        event.fetchContext();
        this.logSender.send((LogEvent)event);
        LogContext.clear();
    }

    public boolean shouldSkip(Object target, Object[] args) {
        if (!(target instanceof DefaultRocketMQListenerContainer.DefaultMessageListenerConcurrently)) {
            return true;
        }
        return !this.checkArgs(args);
    }

    private boolean checkArgs(Object[] args) {
        return args.length >= 1 && args[0] instanceof List && !((List)args[0]).isEmpty() && ((List)args[0]).get(0) instanceof MessageExt;
    }
}

