/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.rocketmq.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.LogEvent;
import com.xforceplus.xlog.core.model.MethodEventListener;
import com.xforceplus.xlog.core.model.impl.RocketMqProducerLogEvent;
import com.xforceplus.xlog.core.model.setting.XlogRocketMqProducerSettings;
import com.xforceplus.xlog.core.utils.ExceptionUtil;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xfrcpls.xcomponent.xrmq.domain.model.BaseRmqMessage;
import com.xfrcpls.xcomponent.xrmq.domain.model.DelayLevel;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.rocketmq.client.impl.CommunicationMode;
import org.apache.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;

public class XlogRocketMqProducerListenerImpl
extends MethodEventListener {
    private final LogSender logSender;
    private final String storeName;
    private final XlogRocketMqProducerSettings xlogRocketMqProducerSettings;

    public XlogRocketMqProducerListenerImpl(LogSender logSender, String storeName, XlogRocketMqProducerSettings xlogRocketMqProducerSettings) {
        this.logSender = logSender;
        this.storeName = storeName;
        this.xlogRocketMqProducerSettings = xlogRocketMqProducerSettings;
    }

    public void beforeCall(Object target, LogEvent logEvent, Object[] args) {
        if (!(logEvent instanceof RocketMqProducerLogEvent)) {
            return;
        }
        Message message = (Message)args[0];
        MessageQueue queue = (MessageQueue)args[1];
        CommunicationMode mode = (CommunicationMode)args[2];
        RocketMqProducerLogEvent event = (RocketMqProducerLogEvent)logEvent;
        event.setTraceId(LogContext.getTraceId());
        event.setParentTraceId(LogContext.getParentTraceId());
        event.setStoreName(this.storeName);
        event.setTenantInfo(LogContext.getTenantInfo());
        try {
            String queueName = message.getTopic();
            int delayTimeLevel = message.getDelayTimeLevel();
            BaseRmqMessage baseRmqMessage = (BaseRmqMessage)JSON.parseObject((byte[])message.getBody(), BaseRmqMessage.class, (Feature[])new Feature[0]);
            Map properties = baseRmqMessage.getProperties();
            event.setName(queueName);
            event.setTags(message.getTags());
            event.setKeys(message.getKeys());
            event.setMode(mode.name());
            event.setMessageProperties(JSON.toJSONString((Object)properties));
            if (delayTimeLevel < DelayLevel.NAMES.length && delayTimeLevel >= 0) {
                event.setDelayLevel(String.format("%s[%d]", DelayLevel.NAMES[delayTimeLevel], delayTimeLevel));
            }
            event.setMessageText(baseRmqMessage.getBody());
            if (baseRmqMessage.getBody().length() <= 0x100000) {
                event.setMessageTextSize(baseRmqMessage.getBody().getBytes(StandardCharsets.UTF_8).length);
            } else {
                event.setMessageTextSize(baseRmqMessage.getBody().length());
            }
            event.setMessageProperties(JSON.toJSONString((Object)properties));
            event.setConsumeQueue(String.format("%s[%d]", queue.getBrokerName(), queue.getQueueId()));
        }
        catch (Throwable throwable) {
            event.setWarnMessage("[Before]\u6536\u96c6RocketMqProducer\u65e5\u5fd7\u6570\u636e\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)throwable));
        }
    }

    public Object afterCall(Object target, LogEvent logEvent, Object[] args, Object result) {
        if (!(logEvent instanceof RocketMqProducerLogEvent)) {
            return result;
        }
        RocketMqProducerLogEvent event = (RocketMqProducerLogEvent)logEvent;
        try {
            SendResult theResult = (SendResult)result;
            SendStatus sendStatus = theResult.getSendStatus();
            event.setSendStatus(sendStatus.name());
            if (sendStatus != SendStatus.SEND_OK) {
                event.setSuccessful(false);
            }
        }
        catch (Throwable throwable) {
            event.setWarnMessage("[After]\u6536\u96c6RocketMqProducer\u65e5\u5fd7\u6570\u636e\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)throwable));
        }
        this.logSender.send((LogEvent)event);
        return result;
    }

    public void onException(Object target, LogEvent logEvent, Throwable ex) {
        if (!(logEvent instanceof RocketMqProducerLogEvent)) {
            return;
        }
        RocketMqProducerLogEvent event = (RocketMqProducerLogEvent)logEvent;
        event.setThrowable(ex);
        this.logSender.send((LogEvent)event);
    }

    public boolean shouldSkip(Object target, Object[] args) {
        if (!(target instanceof DefaultMQProducerImpl)) {
            return true;
        }
        return !this.checkArgs(args);
    }

    private boolean checkArgs(Object[] args) {
        return args.length >= 3 && args[0] instanceof Message && args[1] instanceof MessageQueue && args[2] instanceof CommunicationMode;
    }
}

