/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.autoconfiguration;

import com.alibaba.fastjson.JSON;
import com.xforceplus.xlog.logsender.model.LogAppender;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.logsender.model.ObjectAppender;
import com.xforceplus.xlog.logsender.model.ObjectSender;
import com.xforceplus.xlog.logsender.model.impl.DefaultLogSender;
import com.xforceplus.xlog.logsender.model.impl.DefaultObjectSender;
import com.xforceplus.xlog.logsender.model.impl.KafkaLogAppender;
import com.xforceplus.xlog.logsender.model.impl.MockLogAppender;
import com.xforceplus.xlog.logsender.model.impl.MockObjectAppender;
import com.xforceplus.xlog.logsender.model.impl.OssObjectAppender;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogKafkaSenderProperties;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogMockObjectSenderProperties;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogObjectSenderProperties;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogOssObjectSenderProperties;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.springboot.resttemplate.model.XlogRequestInterceptor;
import com.xforceplus.xlog.springboot.webmvc.model.XlogApiBeforeSendingEventHandler;
import com.xforceplus.xlog.springboot.webmvc.model.XlogApiErrorResponseHandler;
import com.xforceplus.xlog.springboot.webmvc.model.XlogWebFilter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={XlogProperties.class})
@ComponentScan(basePackages={"com.xforceplus.xlog.springboot"})
@ConditionalOnProperty(prefix="xlog", name={"enable"}, havingValue="true")
public class XlogAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(XlogAutoConfiguration.class);
    private final XlogProperties xlogProperties;

    @Autowired
    public XlogAutoConfiguration(XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
        log.info(String.format("Xlog\u542f\u52a8\u4e2d... \u53c2\u6570: %s", JSON.toJSONString((Object)xlogProperties)));
    }

    @Bean
    @Order(value=-2147483648)
    @ConditionalOnProperty(prefix="xlog.api", name={"enable"}, havingValue="true")
    public FilterRegistrationBean webLogFilter(LogSender logSender, @Autowired(required=false) XlogApiErrorResponseHandler apiErrorResponseHandler, @Autowired(required=false) XlogApiBeforeSendingEventHandler apiBeforeSendingEventHandler) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)new XlogWebFilter(this.xlogProperties, logSender, apiErrorResponseHandler, apiBeforeSendingEventHandler), new ServletRegistrationBean[0]);
        filterRegistrationBean.addUrlPatterns(new String[]{"/*"});
        log.info(String.format("xlog.api\u5df2\u542f\u52a8... \u53c2\u6570: %s", JSON.toJSONString((Object)this.xlogProperties.getApi())));
        return filterRegistrationBean;
    }

    @Bean
    @ConditionalOnMissingBean
    public LogSender logSender(@Autowired(required=false) ObjectSender objectSender, List<LogAppender> logAppenderList) {
        DefaultLogSender logSender = new DefaultLogSender();
        for (LogAppender logAppender : logAppenderList) {
            logSender.addLogAppender(logAppender);
        }
        log.info(String.format("xlog.logSender\u5df2\u542f\u52a8... \u53c2\u6570: %s", JSON.toJSONString((Object)this.xlogProperties.getLogSender())));
        return logSender;
    }

    @Bean
    @ConditionalOnProperty(prefix="xlog", name={"log-sender.kafka.enable"}, havingValue="true")
    public LogAppender kafkaLogAppender(@Autowired(required=false) ObjectSender objectSender) {
        XlogKafkaSenderProperties kafkaProperties = this.xlogProperties.getLogSender().getKafka();
        return new KafkaLogAppender(kafkaProperties.getQueueSize(), kafkaProperties.getTopic(), kafkaProperties.getBootstrapServers(), objectSender);
    }

    @Bean
    @ConditionalOnProperty(prefix="xlog", name={"log-sender.mock.enable"}, havingValue="true")
    public LogAppender mockLogAppender(@Autowired(required=false) ObjectSender objectSender) {
        return new MockLogAppender(100, objectSender);
    }

    @Bean
    @ConditionalOnMissingBean
    public ObjectSender objectSender() {
        DefaultObjectSender objectSender = new DefaultObjectSender();
        XlogObjectSenderProperties objectSenderProperties = this.xlogProperties.getObjectSender();
        ObjectAppender objectAppender = this.createObjectAppender(objectSenderProperties);
        objectSender.setObjectAppender(objectAppender);
        log.info(String.format("xlog.objectSender\u5df2\u542f\u52a8... \u53c2\u6570: %s", JSON.toJSONString((Object)this.xlogProperties.getObjectSender())));
        return objectSender;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="xlog.rpc.rest-template", name={"enable"}, havingValue="true")
    public XlogRequestInterceptor xlogRequestInterceptor(LogSender logSender, @Autowired(required=false) List<RestTemplate> restTemplateList) {
        XlogRequestInterceptor xlogRequestInterceptor = new XlogRequestInterceptor(this.xlogProperties, logSender);
        if (restTemplateList != null) {
            for (RestTemplate restTemplate : restTemplateList) {
                List interceptors = restTemplate.getInterceptors();
                interceptors.add(xlogRequestInterceptor);
                log.info(String.format("xlog.rpc.rest-template\u5df2\u542f\u52a8...\u5df2\u6ce8\u5165\u5230RestTemplate[%s]", restTemplate));
            }
        }
        return xlogRequestInterceptor;
    }

    private ObjectAppender createObjectAppender(XlogObjectSenderProperties objectSenderProperties) {
        XlogMockObjectSenderProperties mock;
        if (objectSenderProperties == null) {
            return null;
        }
        ArrayList<Object> objectAppenderList = new ArrayList<Object>();
        XlogOssObjectSenderProperties oss = objectSenderProperties.getOss();
        if (oss != null && oss.isEnable()) {
            OssObjectAppender.Option option = new OssObjectAppender.Option();
            option.setIntranetEndPoint(oss.getIntranetEndPoint());
            option.setInternetEndPoint(oss.getInternetEndPoint());
            option.setBucketName(oss.getBucketName());
            option.setAccessKeyId(oss.getAccessKeyId());
            option.setSecretAccessKey(oss.getSecretAccessKey());
            option.setInternet(oss.isInternet());
            objectAppenderList.add(new OssObjectAppender(100, option));
        }
        if ((mock = objectSenderProperties.getMock()) != null && mock.isEnable()) {
            objectAppenderList.add(new MockObjectAppender(100));
        }
        if (objectAppenderList.size() == 0) {
            return null;
        }
        if (objectAppenderList.size() > 1) {
            throw new IllegalArgumentException("xlog.object-sender\u4e0b\u4e0d\u80fd\u5b58\u57282\u4e2a\u4ee5\u4e0a\u7684\u8282\u70b9(enable=true)");
        }
        return (ObjectAppender)objectAppenderList.get(0);
    }
}

