/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.autoconfiguration.feign;

import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.feign.XlogFeignAdvice;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.springboot.feign.model.XlogFeignInterceptor;
import feign.Feign;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={XlogAutoConfiguration.class})
@ConditionalOnClass(value={Feign.class, LoadBalancerFeignClient.class})
@ConditionalOnProperty(prefix="xlog", name={"rpc.feign.enable"}, havingValue="true")
public class XlogFeignConfiguration {
    private final XlogProperties xlogProperties;

    @Autowired
    public XlogFeignConfiguration(XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public XlogFeignAdvice feignInterceptor(LogSender logSender) {
        return new XlogFeignAdvice(new XlogFeignInterceptor(logSender, this.xlogProperties.getStoreName()));
    }
}

