/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.autoconfiguration.messagebus;

import com.xforceplus.phoenix.messagebus.model.MessageBusConsumerInterceptor;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.messagebus.model.impl.MessageBusConsumerInterceptorImpl;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MessageBusConsumerInterceptor.class})
@AutoConfigureAfter(value={XlogAutoConfiguration.class})
@ConditionalOnProperty(prefix="xlog.message-bus", name={"consumer.enable"}, havingValue="true")
public class XlogMessageBusConsumerConfiguration {
    private final XlogProperties xlogProperties;

    public XlogMessageBusConsumerConfiguration(XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageBusConsumerInterceptor messageBusConsumerInterceptor(LogSender logSender) {
        return new MessageBusConsumerInterceptorImpl(logSender, this.xlogProperties.getStoreName());
    }
}

