/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.autoconfiguration.messagebus;

import com.xforceplus.janus.message.sdk.MBClient;
import com.xforceplus.janus.message.sdk.request.PubRequest;
import com.xforceplus.xlog.messagebus.model.MessageBusProducerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;

@ConditionalOnClass(value={MBClient.class})
@ConditionalOnProperty(prefix="xlog", name={"enable", "message-bus.producer.enable"}, havingValue="true")
public class XlogMessageBusProducerBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(XlogMessageBusProducerBeanPostProcessor.class);
    private final MessageBusProducerInterceptor messageBusProducerInterceptor;

    public XlogMessageBusProducerBeanPostProcessor(MessageBusProducerInterceptor messageBusProducerInterceptor) {
        this.messageBusProducerInterceptor = messageBusProducerInterceptor;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (!(bean instanceof MBClient)) {
            return bean;
        }
        MBClient originalMBClient = (MBClient)bean;
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(MBClient.class);
        enhancer.setCallback((Callback)((MethodInterceptor)(o, method, objects, methodProxy) -> {
            if (!"pub".equals(method.getName()) || objects.length != 1 || !(objects[0] instanceof PubRequest)) {
                return methodProxy.invokeSuper(o, objects);
            }
            PubRequest pubRequest = (PubRequest)objects[0];
            return this.messageBusProducerInterceptor.intercept(pubRequest, () -> methodProxy.invokeSuper(o, objects));
        }));
        MBClient mbClient = (MBClient)enhancer.create();
        mbClient.setUrl(originalMBClient.getUrl());
        mbClient.setToken(originalMBClient.getToken());
        return mbClient;
    }

    public Object postProcessAfterInitialization(Object o, String s) throws BeansException {
        return o;
    }
}

