/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.autoconfiguration.messagebus;

import com.xforceplus.janus.message.sdk.MBClient;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.messagebus.model.MessageBusProducerInterceptor;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.messagebus.XlogMessageBusProducerBeanPostProcessor;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={MBClient.class})
@AutoConfigureAfter(value={XlogAutoConfiguration.class})
@ConditionalOnProperty(prefix="xlog.message-bus", name={"producer.enable"}, havingValue="true")
public class XlogMessageBusProducerConfiguration {
    private final XlogProperties xlogProperties;

    public XlogMessageBusProducerConfiguration(XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public XlogMessageBusProducerBeanPostProcessor xlogMessageBusProducerBeanPostProcessor(LogSender logSender) {
        return new XlogMessageBusProducerBeanPostProcessor(new MessageBusProducerInterceptor(logSender, this.xlogProperties.getStoreName()));
    }
}

