/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.autoconfiguration.rabbitmq;

import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.springboot.autoconfiguration.rabbitmq.XloqRabbitMqConsumerApplicationContextAware;
import com.xforceplus.xlog.springboot.rabbitmq.model.XlogRabbitMqConsumerListener;
import org.springframework.amqp.rabbit.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={XlogAutoConfiguration.class})
@ConditionalOnClass(value={MessagingMessageListenerAdapter.class})
@ConditionalOnProperty(prefix="xlog", name={"rabbit-mq.consumer.enable"}, havingValue="true")
public class XlogRabbitMqConsumerConfiguration {
    private final XlogProperties xlogProperties;

    @Autowired
    public XlogRabbitMqConsumerConfiguration(XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public XlogRabbitMqConsumerListener xlogRabbitMqConsumerListener(LogSender logSender) {
        return new XlogRabbitMqConsumerListener(logSender, this.xlogProperties.getStoreName());
    }

    @Bean
    @ConditionalOnMissingBean
    public XloqRabbitMqConsumerApplicationContextAware xloqRabbitMqConsumerApplicationContextAware() {
        return new XloqRabbitMqConsumerApplicationContextAware();
    }
}

