/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.autoconfiguration.rabbitmq;

import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.springboot.autoconfiguration.rabbitmq.XloqRabbitMqProducerApplicationContextAware;
import com.xforceplus.xlog.springboot.rabbitmq.model.XlogRabbitMqProducerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={XlogAutoConfiguration.class})
@ConditionalOnClass(value={RabbitTemplate.class})
@ConditionalOnProperty(prefix="xlog", name={"rabbit-mq.producer.enable"}, havingValue="true")
public class XlogRabbitMqProducerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(XlogRabbitMqProducerConfiguration.class);
    private final XlogProperties xlogProperties;

    @Autowired
    public XlogRabbitMqProducerConfiguration(XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public XlogRabbitMqProducerListener xlogRabbitMqProducerListener(LogSender logSender) {
        return new XlogRabbitMqProducerListener(logSender, this.xlogProperties.getStoreName());
    }

    @Bean
    @ConditionalOnMissingBean
    public XloqRabbitMqProducerApplicationContextAware xloqRabbitMqProducerApplicationContextAware() {
        return new XloqRabbitMqProducerApplicationContextAware();
    }
}

