/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.autoconfiguration.sqs;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.sqs.model.SqsProducerInterceptor;
import com.xforceplus.xlog.sqs.model.SqsSendData;
import com.xforceplus.xplat.aws.sqs.SqsService;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;

public class XlogSqsProducerBeanPostProcessor
implements BeanPostProcessor {
    private final SqsProducerInterceptor sqsProducerInterceptor;

    public XlogSqsProducerBeanPostProcessor(LogSender logSender, XlogProperties xlogProperties) {
        this.sqsProducerInterceptor = new SqsProducerInterceptor(logSender, xlogProperties.getStoreName());
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (!(bean instanceof SqsService)) {
            return bean;
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(SqsService.class);
        enhancer.setCallback((Callback)((MethodInterceptor)(o, method, objects, methodProxy) -> {
            SqsSendData sqsSendData = this.createSqsSendData(method, objects);
            if (sqsSendData == null) {
                return methodProxy.invokeSuper(o, objects);
            }
            return this.sqsProducerInterceptor.intercept(sqsSendData, () -> methodProxy.invokeSuper(o, objects));
        }));
        return enhancer.create();
    }

    public Object postProcessAfterInitialization(Object o, String s) throws BeansException {
        return o;
    }

    private SqsSendData createSqsSendData(Method method, Object[] objects) {
        SqsSendData sqsSendData = new SqsSendData();
        if ("sendStrMsg".equals(method.getName()) && objects.length == 4 && objects[0] instanceof String && objects[1] instanceof String && objects[2] instanceof String && objects[3] instanceof Map) {
            sqsSendData.setQueueName((String)objects[0]);
            sqsSendData.setMessageText((String)objects[1]);
            sqsSendData.setProperties((Map)objects[3]);
            return sqsSendData;
        }
        if ("sendStrMsg".equals(method.getName()) && objects.length == 3 && objects[0] instanceof String && objects[1] instanceof String && objects[2] instanceof Map) {
            sqsSendData.setQueueName((String)objects[0]);
            sqsSendData.setMessageText((String)objects[1]);
            sqsSendData.setProperties((Map)objects[2]);
            return sqsSendData;
        }
        if ("sendStrMsg".equals(method.getName()) && objects.length == 4 && objects[0] instanceof String && objects[1] instanceof String && objects[2] instanceof Map && objects[3] instanceof JSONObject) {
            sqsSendData.setQueueName((String)objects[0]);
            sqsSendData.setMessageText((String)objects[1]);
            sqsSendData.setProperties((Map)objects[2]);
            return sqsSendData;
        }
        if ("sendBase64Msg".equals(method.getName()) && objects.length == 4 && objects[0] instanceof String && objects[1] instanceof byte[] && objects[2] instanceof Map && objects[3] instanceof JSONObject) {
            sqsSendData.setQueueName((String)objects[0]);
            sqsSendData.setMessageBytes((byte[])objects[1]);
            sqsSendData.setProperties((Map)objects[2]);
            return sqsSendData;
        }
        if ("sendBase64Msg".equals(method.getName()) && objects.length == 3 && objects[0] instanceof String && objects[1] instanceof byte[] && objects[2] instanceof Map) {
            sqsSendData.setQueueName((String)objects[0]);
            sqsSendData.setMessageBytes((byte[])objects[1]);
            sqsSendData.setProperties((Map)objects[2]);
            return sqsSendData;
        }
        if ("sendBase64Msg".equals(method.getName()) && objects.length == 4 && objects[0] instanceof String && objects[1] instanceof byte[] && objects[2] instanceof String && objects[3] instanceof Map) {
            sqsSendData.setQueueName((String)objects[0]);
            sqsSendData.setMessageBytes((byte[])objects[1]);
            sqsSendData.setProperties((Map)objects[3]);
            return sqsSendData;
        }
        return null;
    }
}

