/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.autoconfiguration.sqs;

import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.springboot.autoconfiguration.sqs.XlogSqsProducerBeanPostProcessor;
import com.xforceplus.xplat.aws.sqs.SqsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={SqsService.class})
@AutoConfigureAfter(value={XlogAutoConfiguration.class})
@ConditionalOnProperty(prefix="xlog.sqs", name={"producer.enable"}, havingValue="true")
public class XlogSqsProducerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(XlogSqsProducerConfiguration.class);
    private final XlogProperties xlogProperties;

    @Autowired
    public XlogSqsProducerConfiguration(XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public XlogSqsProducerBeanPostProcessor xlogSqsProducerBeanPostProcessor(LogSender logSender) {
        return new XlogSqsProducerBeanPostProcessor(logSender, this.xlogProperties);
    }
}

