/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.rabbitmq;

import com.xforceplus.xlog.core.utils.JavassistUtil;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlogRabbitMqPreparing {
    private static final Logger log = LoggerFactory.getLogger(XlogRabbitMqPreparing.class);

    public static void prepareProducer() {
        String rabbitmqTemplateClassName = "org.springframework.amqp.rabbit.core.RabbitTemplate";
        try {
            if (!JavassistUtil.checkClassIfExist((String)"org.springframework.amqp.rabbit.core.RabbitTemplate")) {
                log.info(String.format("%s \u672a\u627e\u5230\uff0c\u65e0\u6cd5\u505a\u5b57\u8282\u7801\u53d8\u66f4\u5904\u7406...", "org.springframework.amqp.rabbit.core.RabbitTemplate"));
                return;
            }
            ClassPool pool = ClassPool.getDefault();
            pool.appendClassPath((ClassPath)new LoaderClassPath(Thread.currentThread().getContextClassLoader()));
            CtClass ctClass = pool.get("org.springframework.amqp.rabbit.core.RabbitTemplate");
            CtField listenerField = CtField.make((String)"private com.xforceplus.xlog.springboot.rabbitmq.model.XlogRabbitMqProducerListener listener;", (CtClass)ctClass);
            ctClass.addField(listenerField);
            CtMethod doSendMethodInternal = ctClass.getDeclaredMethod("doSend");
            doSendMethodInternal.setName("doSendInternal");
            CtMethod doSendMethod = CtNewMethod.copy((CtMethod)doSendMethodInternal, (String)"doSend", (CtClass)ctClass, null);
            String doSendMethodBody = "{ try { this.listener.beforeSend($args); $proceed($$); } catch(Exception ex) { this.listener.onException(ex); throw ex; } this.listener.afterSend($args); }";
            doSendMethod.setBody("{ try { this.listener.beforeSend($args); $proceed($$); } catch(Exception ex) { this.listener.onException(ex); throw ex; } this.listener.afterSend($args); }", "this", "doSendInternal");
            ctClass.addMethod(doSendMethod);
            ctClass.toClass();
            log.info(String.format("%s \u5df2\u5b8c\u6210\u5b57\u8282\u7801\u53d8\u66f4\u5904\u7406\u5e76\u8f7d\u5165\u5230ClassLoader\u4e2d...", "org.springframework.amqp.rabbit.core.RabbitTemplate"));
        }
        catch (Exception ex) {
            log.error(String.format("%s \u5b57\u8282\u7801\u53d8\u66f4\u5931\u8d25...", "org.springframework.amqp.rabbit.core.RabbitTemplate"), (Throwable)ex);
        }
    }

    public static void prepareConsumer() {
        String rabbitmqListenerAdapterClassName = "org.springframework.amqp.rabbit.listener.adapter.MessagingMessageListenerAdapter";
        try {
            if (!JavassistUtil.checkClassIfExist((String)"org.springframework.amqp.rabbit.listener.adapter.MessagingMessageListenerAdapter")) {
                log.info(String.format("%s \u672a\u627e\u5230\uff0c\u65e0\u6cd5\u505a\u5b57\u8282\u7801\u53d8\u66f4\u5904\u7406...", "org.springframework.amqp.rabbit.listener.adapter.MessagingMessageListenerAdapter"));
                return;
            }
            ClassPool pool = ClassPool.getDefault();
            pool.appendClassPath((ClassPath)new LoaderClassPath(Thread.currentThread().getContextClassLoader()));
            CtClass ctClass = pool.get("org.springframework.amqp.rabbit.listener.adapter.MessagingMessageListenerAdapter");
            CtField listenerField = CtField.make((String)"private static com.xforceplus.xlog.springboot.rabbitmq.model.XlogRabbitMqConsumerListener listener;", (CtClass)ctClass);
            ctClass.addField(listenerField);
            CtMethod onMessageMethodInternal = ctClass.getDeclaredMethod("onMessage");
            onMessageMethodInternal.setName("onMessageInternal");
            CtMethod onMessageMethod = CtNewMethod.copy((CtMethod)onMessageMethodInternal, (String)"onMessage", (CtClass)ctClass, null);
            String onMessageMethodBody = "{ try { this.listener.beforeSend($args); $proceed($$); } catch(Exception ex) { this.listener.onException(ex); throw ex; } this.listener.afterSend($args); }";
            onMessageMethod.setBody("{ try { this.listener.beforeSend($args); $proceed($$); } catch(Exception ex) { this.listener.onException(ex); throw ex; } this.listener.afterSend($args); }", "this", "onMessageInternal");
            ctClass.addMethod(onMessageMethod);
            ctClass.toClass();
            log.info(String.format("%s \u5df2\u5b8c\u6210\u5b57\u8282\u7801\u53d8\u66f4\u5904\u7406\u5e76\u8f7d\u5165\u5230ClassLoader\u4e2d...", "org.springframework.amqp.rabbit.listener.adapter.MessagingMessageListenerAdapter"));
        }
        catch (Exception ex) {
            log.error(String.format("%s \u5b57\u8282\u7801\u53d8\u66f4\u5931\u8d25...", "org.springframework.amqp.rabbit.listener.adapter.MessagingMessageListenerAdapter"), (Throwable)ex);
        }
    }
}

