/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.rabbitmq.model;

import com.alibaba.fastjson.JSON;
import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.LogEvent;
import com.xforceplus.xlog.core.model.impl.RabbitMqConsumerLogEvent;
import com.xforceplus.xlog.core.utils.ExceptionUtil;
import com.xforceplus.xlog.logsender.model.LogSender;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;

public class XlogRabbitMqConsumerListener {
    private static ThreadLocal<RabbitMqConsumerLogEvent> cache = new ThreadLocal();
    private final LogSender logSender;
    private final String storeName;

    public XlogRabbitMqConsumerListener(LogSender logSender, String storeName) {
        this.logSender = logSender;
        this.storeName = storeName;
    }

    public void beforeSend(Object[] args) {
        LogContext.init();
        RabbitMqConsumerLogEvent event = new RabbitMqConsumerLogEvent();
        cache.set(event);
        event.setStoreName(this.storeName);
        try {
            Message message = (Message)args[0];
            MessageProperties properties = message.getMessageProperties();
            Map headers = properties.getHeaders();
            if (headers.containsKey("X-Trace-Id")) {
                LogContext.setTraceId((String)((String)headers.get("X-Trace-Id")));
            }
            event.setTraceId(LogContext.getTraceId());
            event.setName(properties.getConsumerQueue());
            event.setMessageId(properties.getMessageId());
            event.setMessageProperties(JSON.toJSONString((Object)headers));
            byte[] body = message.getBody();
            if (body != null) {
                event.setMessageText(new String(body, StandardCharsets.UTF_8));
                event.setMessageTextSize(body.length);
            }
        }
        catch (Throwable throwable) {
            event.setMessage("\u6536\u96c6RabbitMqConsumer\u65e5\u5fd7\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)throwable));
        }
    }

    public void afterSend(Object[] args) {
        RabbitMqConsumerLogEvent event = cache.get();
        cache.remove();
        event.getExt().putAll(LogContext.getAllPoint());
        this.logSender.send((LogEvent)event);
        LogContext.clear();
    }

    public void onException(Exception exception) {
        RabbitMqConsumerLogEvent event = cache.get();
        cache.remove();
        event.setThrowable((Throwable)exception);
        event.getExt().putAll(LogContext.getAllPoint());
        this.logSender.send((LogEvent)event);
        LogContext.clear();
    }
}

