/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.webmvc.model;

import com.xforceplus.xlog.core.utils.ExceptionUtil;
import com.xforceplus.xlog.core.utils.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class XlogHttpServletRequest
extends HttpServletRequestWrapper {
    private final ByteArrayOutputStream bodyStream = new ByteArrayOutputStream();
    private int bodySize;

    public XlogHttpServletRequest(HttpServletRequest request) {
        super(request);
        try {
            this.bodySize = IOUtil.copy((InputStream)request.getInputStream(), (OutputStream)this.bodyStream, (byte[])new byte[4096]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            String exceptionDesc = "\u590d\u5236\u8bf7\u6c42\u62a5\u6587\u4f53\u65f6\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)e);
            byte[] exceptionDescBytes = exceptionDesc.getBytes(StandardCharsets.UTF_8);
            this.bodyStream.write(exceptionDescBytes, 0, exceptionDescBytes.length);
            this.bodySize = exceptionDescBytes.length;
        }
    }

    public ServletInputStream getInputStream() {
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.bodyStream.toByteArray());
        return new ServletInputStream(){

            public boolean isFinished() {
                return byteArrayInputStream.available() == 0;
            }

            public boolean isReady() {
                return byteArrayInputStream.available() > 0;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() throws IOException {
                return byteArrayInputStream.read();
            }
        };
    }

    public Map<String, String> getHeaderMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration headerNames = this.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headName = (String)headerNames.nextElement();
            result.put(headName, this.getHeader(headName));
        }
        return result;
    }

    public String getBody() {
        try {
            return new String(this.bodyStream.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (Throwable e) {
            return "\u83b7\u53d6\u8bf7\u6c42\u62a5\u6587\u4f53\u65f6\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)e);
        }
    }

    public int getBodySize() {
        return this.bodySize;
    }
}

