/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.autoconfiguration.rabbitmq;

import com.alibaba.fastjson.JSON;
import com.xforceplus.xlog.core.model.MethodListener;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.springboot.rabbitmq.model.XlogRabbitMqProducerListenerImpl;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={XlogAutoConfiguration.class})
@ConditionalOnClass(value={RabbitTemplate.class})
@ConditionalOnProperty(prefix="xlog", name={"rabbit-mq.producer.enabled"}, havingValue="true")
public class XlogRabbitMqProducerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(XlogRabbitMqProducerConfiguration.class);
    private final XlogProperties xlogProperties;

    @Autowired
    public XlogRabbitMqProducerConfiguration(XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    @Bean(value={"xlogRabbitMqProducerListener"})
    @ConditionalOnMissingBean(name={"xlogRabbitMqProducerListener"})
    public MethodListener xlogRabbitMqProducerListener(LogSender logSender) {
        XlogRabbitMqProducerListenerImpl listener = new XlogRabbitMqProducerListenerImpl(logSender, this.xlogProperties.getStoreName());
        Field listenerField = RabbitTemplate.class.getDeclaredField("_listener");
        listenerField.set(RabbitTemplate.class, listener);
        log.info(String.format("xlog.rabbit-mq.producer\u5df2\u542f\u52a8... \u53c2\u6570: %s", JSON.toJSON((Object)this.xlogProperties.getRabbitMq().getProducer())));
        return listener;
    }
}

