/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.autoconfiguration.sqs;

import com.alibaba.fastjson.JSON;
import com.xforceplus.xlog.core.model.MethodListener;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.sqs.model.impl.SqsProducerListenerImpl;
import com.xforceplus.xplat.aws.sqs.SqsService;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={SqsService.class})
@AutoConfigureAfter(value={XlogAutoConfiguration.class})
@ConditionalOnProperty(prefix="xlog", name={"sqs.producer.enabled"}, havingValue="true")
public class XlogSqsProducerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(XlogSqsProducerConfiguration.class);
    private final XlogProperties xlogProperties;

    @Autowired
    public XlogSqsProducerConfiguration(XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    @Bean(value={"xlogSqsProducerListener"})
    @ConditionalOnMissingBean(name={"xlogSqsProducerListener"})
    public MethodListener xlogSqsProducerListener(LogSender logSender) {
        SqsProducerListenerImpl listener = new SqsProducerListenerImpl(logSender, this.xlogProperties.getStoreName());
        Field listenerField = SqsService.class.getDeclaredField("_listener");
        listenerField.set(SqsService.class, listener);
        log.info(String.format("xlog.sqs.producer\u5df2\u542f\u52a8... \u53c2\u6570: %s", JSON.toJSON((Object)this.xlogProperties.getSqs().getProducer())));
        return listener;
    }
}

