/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.webmvc.model;

import com.alibaba.fastjson.JSON;
import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.LogEvent;
import com.xforceplus.xlog.core.model.impl.HttpLogEvent;
import com.xforceplus.xlog.core.utils.ExceptionUtil;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.springboot.webmvc.model.XlogApiBeforeSendingEventHandler;
import com.xforceplus.xlog.springboot.webmvc.model.XlogApiErrorResponse;
import com.xforceplus.xlog.springboot.webmvc.model.XlogApiErrorResponseHandler;
import com.xforceplus.xlog.springboot.webmvc.model.XlogHttpServletRequest;
import com.xforceplus.xlog.springboot.webmvc.model.XlogHttpServletResponse;
import com.xforceplus.xlog.springboot.webmvc.model.impl.XlogDefaultApiErrorResponseHandler;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.NestedServletException;

public class XlogWebFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(XlogWebFilter.class);
    private final String storeName;
    private final Pattern pattern;
    private final LogSender logSender;
    private final XlogApiErrorResponseHandler apiErrorResponseHandler;
    private final XlogApiBeforeSendingEventHandler apiBeforeSendingEventHandler;
    private final XlogApiErrorResponseHandler defaultApiErrorResponseHandler = new XlogDefaultApiErrorResponseHandler();

    public XlogWebFilter(XlogProperties properties, LogSender logSender, XlogApiErrorResponseHandler apiErrorResponseHandler, XlogApiBeforeSendingEventHandler apiBeforeSendingEventHandler) {
        this.storeName = properties.getStoreName();
        this.logSender = logSender;
        this.apiErrorResponseHandler = apiErrorResponseHandler;
        this.apiBeforeSendingEventHandler = apiBeforeSendingEventHandler;
        this.pattern = StringUtils.isNotBlank((CharSequence)properties.getApi().getUrlPattern()) ? Pattern.compile(properties.getApi().getUrlPattern()) : Pattern.compile(".*");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String uri = ((HttpServletRequest)servletRequest).getRequestURI();
        if (!this.isMatch(uri)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        XlogHttpServletRequest request = new XlogHttpServletRequest((HttpServletRequest)servletRequest);
        XlogHttpServletResponse response = new XlogHttpServletResponse((HttpServletResponse)servletResponse);
        this.doActualFilter(filterChain, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doActualFilter(FilterChain filterChain, XlogHttpServletRequest request, XlogHttpServletResponse response) throws IOException, ServletException {
        LogContext.init();
        if (request.getHeader("X-Trace-Id") != null) {
            LogContext.setTraceId((String)request.getHeader("X-Trace-Id"));
        }
        HttpLogEvent event = new HttpLogEvent();
        event.setHeaders(JSON.toJSONString(request.getHeaderMap()));
        event.setRequestText(request.getBody());
        event.setRequestSize(request.getBodySize());
        event.setMethod(request.getMethod());
        event.setName(request.getRequestURI());
        event.setRemoteIp(request.getRemoteHost());
        event.setUrl(this.getFullUrl(request));
        event.setUserAgent(request.getHeader("user-agent"));
        event.setStoreName(this.storeName);
        event.setType("Api");
        event.setTraceId(LogContext.getTraceId());
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Throwable ex) {
            log.debug("API\u5f02\u5e38", ex);
            Throwable throwable = ex;
            if (ex instanceof NestedServletException && ex.getCause() != null) {
                throwable = ex.getCause();
            }
            event.setThrowable(throwable);
            this.handleErrorResponse(response, event, throwable);
        }
        finally {
            event.getExt().putAll(LogContext.getAllPoint());
            event.setResponseText(response.getBody());
            event.setResponseSize(response.getBodySize());
            event.setHttpStatus(response.getStatus() + "");
            if (this.beforeSend(event)) {
                this.logSender.send((LogEvent)event);
            }
            LogContext.clear();
        }
    }

    private boolean beforeSend(HttpLogEvent event) {
        if (this.apiBeforeSendingEventHandler == null) {
            return true;
        }
        try {
            return this.apiBeforeSendingEventHandler.handle(event);
        }
        catch (Throwable throwable) {
            event.setMessage("\u53d1\u9001\u524d\u7684\u56de\u8c03\u5904\u7406\u53d1\u751f\u5f02\u5e38\uff01" + ExceptionUtil.toDesc((Throwable)throwable));
            return true;
        }
    }

    private void handleErrorResponse(XlogHttpServletResponse response, HttpLogEvent event, Throwable throwable) {
        try {
            XlogApiErrorResponse errorResponse = this.apiErrorResponseHandler != null ? this.apiErrorResponseHandler.handle(event, throwable) : this.defaultApiErrorResponseHandler.handle(event, throwable);
            response.setHeader("Content-Type", "application/json; charset=UTF-8");
            response.setStatus(errorResponse.getHttpStatusCode());
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(errorResponse.getResponseBody().getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException("Xlog: WriteErrorResponse Exception!", throwable);
        }
    }

    private boolean isMatch(String uri) {
        return this.pattern.matcher(uri).matches();
    }

    private String getFullUrl(XlogHttpServletRequest request) {
        StringBuffer requestURL = request.getRequestURL();
        String queryString = request.getQueryString();
        if (requestURL == null) {
            return "";
        }
        if (StringUtils.isNotBlank((CharSequence)queryString)) {
            return String.format("%s?%s", requestURL, queryString);
        }
        return requestURL.toString();
    }
}

