/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.autoconfiguration.mybatis;

import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.mybatis.XlogMyBatisExecutorInterceptor;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import org.apache.ibatis.plugin.Interceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@ConditionalOnClass(value={Interceptor.class})
@AutoConfigureAfter(value={XlogAutoConfiguration.class})
@ConditionalOnProperty(prefix="xlog.mybatis", name={"enabled"}, havingValue="true")
public class XlogMyBatisConfiguration {
    private final XlogProperties xlogProperties;

    @Autowired
    public XlogMyBatisConfiguration(XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    @Bean
    @Order(value=-2147483548)
    @ConditionalOnMissingBean
    public XlogMyBatisExecutorInterceptor xlogMyBatisExecutorInterceptor(LogSender logSender) {
        return new XlogMyBatisExecutorInterceptor(this.xlogProperties.getStoreName(), logSender, this.xlogProperties.getMybatis().isSqlEnabled(), this.xlogProperties.getMybatis().isSqlResultEnabled());
    }
}

