/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.autoconfiguration.sqs;

import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.sqs.model.SqsConsumerInterceptor;
import com.xforceplus.xplat.aws.SqsData;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class XlogSqsConsumerAdvice {
    private final SqsConsumerInterceptor sqsConsumerInterceptor;

    public XlogSqsConsumerAdvice(LogSender logSender, XlogProperties xlogProperties) {
        this.sqsConsumerInterceptor = new SqsConsumerInterceptor(logSender, xlogProperties.getStoreName());
    }

    @Around(value="execution (* com.xforceplus.xplat.aws.sqs.listener.AbsSQSListener.cusListener(..))")
    public Object cut(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        SqsData sqsData = (SqsData)proceedingJoinPoint.getArgs()[0];
        return this.sqsConsumerInterceptor.intercept(sqsData, () -> (Boolean)proceedingJoinPoint.proceed());
    }
}

