package com.xforceplus.xlog.springboot.autoconfiguration.janus;

import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.xlog.core.model.MethodEventListener;
import com.xforceplus.xlog.janus.model.impl.JanusProducerListenerImpl;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import lombok.SneakyThrows;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.lang.reflect.Field;

/**
 * @author zhuxingsheng@gmail.com
 * @description: 集成平台生产者配置
 * @date 2023/11/2 11:48
 */
@Configuration
@ConditionalOnClass(MCFactory.class)
@AutoConfigureAfter(XlogAutoConfiguration.class)
@ConditionalOnProperty(prefix = "xlog", name = {"enabled", "janus.producer.enabled"}, havingValue = "true")
public class XlogJanusProducerConfiguration {

    private final XlogProperties xlogProperties;

    /**
     * 构造函数
     *
     * @param xlogProperties xlog配置
     */
    public XlogJanusProducerConfiguration(final XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    /**
     * 注入消息总线生产者监听器实例
     *
     * @param logSender 日志发送者
     * @return 消息总线生产者监听器实例
     */
    @Bean("xlogJanusProducerListener")
    @ConditionalOnMissingBean(name = "xlogJanusProducerListener")
    @SneakyThrows
    public MethodEventListener xlogJanusProducerListener(final LogSender logSender) {
        final MethodEventListener listener = new JanusProducerListenerImpl(logSender, this.xlogProperties.getStoreName());
        final Field listenerField = MCFactory.class.getDeclaredField("_listener");
        listenerField.set(MCFactory.class, listener);
        return listener;
    }

}
