package com.xforceplus.xlog.springboot.autoconfiguration.mybatis;

import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.mybatis.XlogMyBatisExecutorInterceptor;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import org.apache.ibatis.plugin.Interceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

/**
 * MyBatis配置器
 *
 * @author gulei
 * @date 2023/01/19
 */
@Configuration
@ConditionalOnClass({Interceptor.class})
@AutoConfigureAfter(XlogAutoConfiguration.class)
@ConditionalOnProperty(prefix = "xlog", name = {"enabled", "mybatis.enabled"}, havingValue = "true")
public class XlogMyBatisConfiguration {
    private final XlogProperties xlogProperties;

    /**
     * 构造函数
     *
     * @param xlogProperties XLog配置
     */
    @Autowired
    public XlogMyBatisConfiguration(final XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    /**
     * 注入MyBatis插件实例
     *
     * @param logSender 日志发送器
     * @return MyBatis插件实例
     */
    @Bean
    @Order(Ordered.HIGHEST_PRECEDENCE + 100)
    @ConditionalOnMissingBean
    public XlogMyBatisExecutorInterceptor xlogMyBatisExecutorInterceptor(final LogSender logSender) {
        return new XlogMyBatisExecutorInterceptor(
                this.xlogProperties.getStoreName(),
                logSender,
                this.xlogProperties.getMybatis().isSqlEnabled(),
                this.xlogProperties.getMybatis().isSqlResultEnabled()
        );
    }
}
