package com.xforceplus.xlog.springboot.autoconfiguration.setting;

import com.alibaba.fastjson.JSON;
import com.xforceplus.xlog.core.model.setting.XlogSettings;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogSettingProperties;
import com.xforceplus.xlog.springboot.setting.model.XlogSettingWorker;
import com.xforceplus.xlog.springboot.setting.model.impl.XlogRemoteSettingWorkerImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * XlogRemoteSettingConfiguration
 *
 * @author gulei
 * @date 2024/02/10
 */
@Slf4j
@Configuration
@AutoConfigureAfter(XlogApolloSettingConfiguration.class)
@ConditionalOnProperty(prefix = "xlog", name = {"enabled", "setting.enabled"}, havingValue = "true")
public class XlogRemoteSettingConfiguration {
    private final XlogProperties xlogProperties;

    @Autowired
    public XlogRemoteSettingConfiguration(final XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public XlogSettings getXlogSettings() {
        return new XlogSettings();
    }

    @Bean
    @ConditionalOnMissingBean(XlogSettingWorker.class)
    @ConditionalOnProperty(prefix = "xlog.setting", name = "url")
    public XlogSettingWorker getXlogRemoteSettingWorker(XlogSettings xlogSettings) {
        final XlogSettingProperties settingProperties = this.xlogProperties.getSetting();
        final XlogSettingWorker worker = new XlogRemoteSettingWorkerImpl(settingProperties, xlogSettings);

        try {
            worker.init();
            log.info(String.format("xlog.setting[remote]已启动... 参数: %s", JSON.toJSONString(settingProperties)));
        } catch (Exception ex) {
            log.warn("XlogSetting[remote]数据初始化加载时异常!", ex);
        }

        return worker;
    }
}
