package com.xforceplus.xlog.springboot.autoconfiguration.xlogevent;

import com.xforceplus.xlog.springboot.method.model.XlogMethodInterceptor;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

/**
 * XlogEventAdvice
 *
 * @author gulei
 * @date 2024/03/18
 */
@Aspect
public class XlogMethodAdvice {
    private final XlogMethodInterceptor interceptor;

    public XlogMethodAdvice(final XlogMethodInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    @Around("@annotation(com.xforceplus.xlog.springboot.xlogmethod.annotation.XlogMethod)")
    public Object cut(ProceedingJoinPoint point) throws Throwable {
        final Signature signature = point.getSignature();
        return interceptor.intercept(signature.getDeclaringTypeName(), signature.getName(), "aop", point.getArgs(), point::proceed);
    }
}
