package com.xforceplus.xlog.springboot.autoconfiguration.xlogevent;

import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.springboot.method.model.XlogMethodInterceptor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * XlogMethodConfiguration
 *
 * @author gulei
 * @date 2024/03/18
 */
@Slf4j
@Configuration
@AutoConfigureAfter(XlogAutoConfiguration.class)
@ConditionalOnProperty(prefix = "xlog", name = {"enabled"}, havingValue = "true")
public class XlogMethodConfiguration {
    private final XlogProperties xlogProperties;

    /**
     * 构造函数
     *
     * @param xlogProperties xlog配置
     */
    @Autowired
    public XlogMethodConfiguration(final XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public XlogMethodInterceptor xlogMethodInterceptor(final LogSender logSender) {
        return new XlogMethodInterceptor(logSender, xlogProperties.getStoreName());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix = "xlog", name = {"method.aop.enabled"}, havingValue = "true")
    public XlogMethodAdvice xlogMethodAdvice(final XlogMethodInterceptor interceptor) {
        return new XlogMethodAdvice(interceptor);
    }
}
