package com.xforceplus.xlog.springboot.autoconfiguration.xlogversion;

import com.alibaba.fastjson.JSON;
import com.xforceplus.xlog.core.model.XlogVersion;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.logsender.model.VersionLogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.springboot.xlogversion.XlogVersionSchedule;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;

/**
 * XlogVersionConfiguration
 *
 * @author gulei
 * @date 2024/03/18
 */
@Slf4j
@Configuration
@EnableScheduling
@AutoConfigureAfter(XlogAutoConfiguration.class)
@ConditionalOnProperty(prefix = "xlog", name = {"enabled"}, havingValue = "true")
public class XlogVersionConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public XlogVersion getXlogVersion() {
        return new XlogVersion();
    }

    @Bean
    @ConditionalOnMissingBean
    public VersionLogSender getVersionLogSender(final LogSender logSender, final XlogVersion version, XlogProperties xlogProperties) {
        final VersionLogSender versionLogSender = new VersionLogSender(logSender, version, xlogProperties.getStoreName());
        versionLogSender.send("Startup", JSON.toJSONString(xlogProperties));
        return versionLogSender;
    }

    @Bean
    @ConditionalOnMissingBean
    public XlogVersionSchedule xlogVersionSchedule(final VersionLogSender versionLogSender, final XlogProperties xlogProperties) {
        return new XlogVersionSchedule(versionLogSender, xlogProperties);
    }
}
