package com.xforceplus.xlog.springboot.webmvc.model;

import com.xforceplus.xlog.core.model.impl.HttpLogEvent;

/**
 * Api类型的日志在发送前的回调处理
 *
 * @author gulei
 */
public interface XlogApiBeforeSendingEventHandler {
    /**
     * 日志处理
     *
     * 参数中内容可被修改，修改结果会保留下来
     *
     * 返回true代表保留日志，返回false代表丢弃日志
     *
     * @param event Api类型的日志
     * @return 是否保留
     */
    boolean handle(final HttpLogEvent event);
}
