package com.xforceplus.xlog.springboot.autoconfiguration.sqs;

import com.xforceplus.xlog.core.model.setting.XlogSqsSettings;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.sqs.model.SqsConsumerInterceptor;
import com.xforceplus.xplat.aws.SqsData;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

import javax.annotation.Nullable;

@Aspect
public class XlogSqsConsumerAdvice {
    private final SqsConsumerInterceptor sqsConsumerInterceptor;

    public XlogSqsConsumerAdvice(final LogSender logSender, final XlogProperties xlogProperties, @Nullable final XlogSqsSettings xlogSqsSettings) {
        this.sqsConsumerInterceptor = new SqsConsumerInterceptor(logSender, xlogProperties.getStoreName(), xlogSqsSettings);
    }

    @Around("execution (* com.xforceplus.xplat.aws.sqs.listener.AbsSQSListener.cusListener(..))")
    public Object cut(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        final SqsData sqsData = (SqsData)proceedingJoinPoint.getArgs()[0];
        return sqsConsumerInterceptor.intercept(sqsData, () -> (Boolean)proceedingJoinPoint.proceed());
    }
}
