package com.xforceplus.xlog.springboot.schedule.model;

import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.impl.ScheduleLogEvent;
import com.xforceplus.xlog.core.utils.Callable;
import com.xforceplus.xlog.logsender.model.LogSender;

import static com.xforceplus.xlog.core.constant.EventType.SCHEDULE;

/**
 * XlogScheduleInterceptor
 *
 * @author gulei
 * @date 2024/02/09
 */
public class XlogScheduleInterceptor {
    private final LogSender logSender;
    private final String storeName;

    public XlogScheduleInterceptor(final LogSender logSender, final String storeName) {
        this.logSender = logSender;
        this.storeName = storeName;
    }

    public Object intercept(String name, Callable<Object> callable) throws Throwable {
        LogContext.init();

        final String traceId = LogContext.getTraceId();

        final ScheduleLogEvent event = new ScheduleLogEvent();
        event.setName(name);
        event.setStoreName(storeName);
        event.setType(SCHEDULE.toName());
        event.setTraceId(traceId);

        // 执行远程调用
        try {
            return callable.call();
        } catch (Throwable throwable) {
            event.setThrowable(throwable);

            throw throwable;
        } finally {
            event.fetchContext();

            // 发送埋点日志
            this.logSender.send(event);

            LogContext.clear();
        }
    }
}
