package com.xforceplus.xlog.springboot.webmvc.model.impl;

import com.alibaba.fastjson.JSON;
import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.impl.HttpLogEvent;
import com.xforceplus.xlog.core.utils.ExceptionUtil;
import com.xforceplus.xlog.springboot.webmvc.model.XlogApiErrorResponse;
import com.xforceplus.xlog.springboot.webmvc.model.XlogApiErrorResponseHandler;
import com.xforceplus.xlog.springboot.webmvc.model.XlogErrorResponseDTO;

public class XlogDefaultApiErrorResponseHandler implements XlogApiErrorResponseHandler {
    @Override
    public XlogApiErrorResponse handle(HttpLogEvent event, Throwable throwable) {
        final XlogDefaultApiErrorResponse result = new XlogDefaultApiErrorResponse();

        final XlogErrorResponseDTO errorResponseDTO = new XlogErrorResponseDTO();
        errorResponseDTO.setMessage(ExceptionUtil.toDesc(throwable));
        errorResponseDTO.setTraceId(LogContext.getTraceId());

        result.setResponseBody(JSON.toJSONString(errorResponseDTO));

        return result;
    }
}
