package com.xforceplus.xlog.springboot.autoconfiguration.xplatcommonconfig;

import com.xforceplus.xlog.core.constant.Constants;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

import javax.servlet.http.HttpServletRequest;

/**
 * XlogGlobalExceptionAdvice
 *
 * @author gulei
 * @date 2023/1/21
 */
@Aspect
public class XlogGlobalExceptionAdvice {

    public XlogGlobalExceptionAdvice() {

    }

    /**
     * 切点
     *
     * @param proceedingJoinPoint 执行点
     * @return 执行结果
     * @throws Throwable 异常
     */
    @Around("execution(* com.xforceplus.common.config.exception.GlobalExceptionAdvice.defaultErrorHander(..))")
    public Object cut(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        final Object[] args = proceedingJoinPoint.getArgs();

        // HttpServletRequest request, HttpServletResponse response, Throwable exception
        if (args[0] instanceof HttpServletRequest && args[2] instanceof Throwable) {
            ((HttpServletRequest)args[0]).setAttribute(Constants.Api.RequestAttribute.CONTROLLER_ADVICE_EXCEPTION, args[2]);
        }

        return proceedingJoinPoint.proceed();
    }
}
