package com.xforceplus.xlog.springboot.webmvc.model;

import com.xforceplus.xlog.core.utils.ExceptionUtil;
import com.xforceplus.xlog.core.utils.IOUtil;
import lombok.SneakyThrows;

import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class XlogHttpServletRequest extends HttpServletRequestWrapper {
    private final ByteArrayOutputStream bodyStream = new ByteArrayOutputStream();
    private int bodySize;
    private String contentType;

    public XlogHttpServletRequest(HttpServletRequest request) {
        super(request);

        try {
            this.contentType = request.getContentType();
            if (this.contentType != null && this.contentType.startsWith("multipart")) {
                return;
            }

            this.bodySize = IOUtil.copy(request.getInputStream(), this.bodyStream, new byte[4096]);
        } catch (Throwable e) {
            e.printStackTrace();

            final String exceptionDesc = "复制请求报文体时异常: " + ExceptionUtil.toDesc(e);
            final byte[] exceptionDescBytes = exceptionDesc.getBytes(StandardCharsets.UTF_8);
            this.bodyStream.write(exceptionDescBytes, 0, exceptionDescBytes.length);
            this.bodySize = exceptionDescBytes.length;
        }
    }

    @Override
    @SneakyThrows
    public ServletInputStream getInputStream() {
        if (this.contentType != null && this.contentType.startsWith("multipart")) {
            return super.getInputStream();
        }

        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bodyStream.toByteArray());

        return new ServletInputStream() {
            @Override
            public boolean isFinished() {
                return byteArrayInputStream.available() == 0;
            }

            @Override
            public boolean isReady() {
                return byteArrayInputStream.available() > 0;
            }

            @Override
            public void setReadListener(ReadListener readListener) {
            }

            @Override
            public int read() throws IOException {
                return byteArrayInputStream.read();
            }
        };
    }

    public Map<String, String> getHeaderMap() {
        final Map<String, String> result = new HashMap<>();

        final Enumeration<String> headerNames = this.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            final String headName = headerNames.nextElement();
            result.put(headName, this.getHeader(headName));
        }

        return result;
    }

    public String getBody() {
        try {
            return new String(bodyStream.toByteArray(), StandardCharsets.UTF_8);
        } catch (Throwable e) {
            return "获取请求报文体时异常: " + ExceptionUtil.toDesc(e);
        }
    }

    public int getBodySize() {
        return this.bodySize;
    }
}
