package com.xforceplus.xlog.springboot.webmvc.model;

import com.xforceplus.xlog.core.utils.ExceptionUtil;

import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class XlogHttpServletResponse extends HttpServletResponseWrapper {

    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

    public XlogHttpServletResponse(HttpServletResponse response) {
        super(response);
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        final ServletOutputStream servletOutputStream = super.getOutputStream();

        return new ServletOutputStream() {
            @Override
            public boolean isReady() {
                return servletOutputStream.isReady();
            }

            @Override
            public void setWriteListener(WriteListener writeListener) {
                servletOutputStream.setWriteListener(writeListener);
            }

            @Override
            public void write(int b) throws IOException {
                servletOutputStream.write(b);
                outputStream.write(b);
            }
        };
    }

    public String getBody() {
        try {
            return outputStream.toString(StandardCharsets.UTF_8.name());
        } catch (Throwable e) {
            return "获取响应报文体时异常: " + ExceptionUtil.toDesc(e);
        }
    }

    public int getBodySize() {
        return outputStream.size();
    }
}
