package com.xforceplus.xlog.springboot.autoconfiguration.elasticsearch;

import com.xforceplus.xlog.core.model.MethodEventListener;
import com.xforceplus.xlog.core.model.setting.XlogElasticsearchSettings;
import com.xforceplus.xlog.core.model.setting.XlogSettings;
import com.xforceplus.xlog.elasticsearch.model.impl.XlogElasticsearchRestClientListenerImpl;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.elasticsearch.client.RestClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.lang.reflect.Field;
import java.util.Optional;

/**
 * XlogElasticsearchRestClientConfiguration
 *
 * @author gulei
 * @date 2024/03/20
 */
@Slf4j
@Configuration
@AutoConfigureAfter(XlogAutoConfiguration.class)
@ConditionalOnClass({RestClient.class})
@ConditionalOnProperty(prefix = "xlog", name = {"enabled", "elasticsearch.rest-client.enabled"}, havingValue = "true")
public class XlogElasticsearchRestClientConfiguration {
    private final XlogProperties xlogProperties;

    public XlogElasticsearchRestClientConfiguration(final XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    @Bean("xlogElasticSearchRestClientListener")
    @ConditionalOnMissingBean(name = "xlogElasticSearchRestClientListener")
    @SneakyThrows
    public MethodEventListener xlogElasticSearchRestClientListener(
            final LogSender logSender,
            final @Autowired(required = false) XlogSettings xlogSettings
    ) {
        final XlogElasticsearchSettings esSettings = Optional.ofNullable(xlogSettings).map(XlogSettings::getElasticsearch).orElse(null);
        final MethodEventListener listener = new XlogElasticsearchRestClientListenerImpl(logSender, this.xlogProperties.getStoreName(), esSettings);
        final Field listenerField = RestClient.class.getDeclaredField("_listener");
        listenerField.set(RestClient.class, listener);
        log.info("xlog.elasticsearch已启动... ");
        return listener;
    }
}
