package com.xforceplus.xlog.springboot.autoconfiguration.feign;

import com.xforceplus.xlog.springboot.feign.model.XlogFeignInterceptor;
import feign.Request;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Feign通知
 *
 * @author gulei
 * @date 2023/01/19
 */
@Aspect
public class XlogFeignAdvice {
    private final XlogFeignInterceptor feignInterceptor;

    /**
     * 构造函数
     *
     * @param feignInterceptor Feign拦截器
     */
    @Autowired
    public XlogFeignAdvice(final XlogFeignInterceptor feignInterceptor) {
        this.feignInterceptor = feignInterceptor;
    }

    /**
     * 切入点
     *
     * @param proceedingJoinPoint 处理点
     * @return 处理结果
     * @throws Throwable 异常
     */
    @Around("execution (* org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient.execute(..))")
    public Object cut(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        final Object[] args = proceedingJoinPoint.getArgs();
        return this.feignInterceptor.intercept((Request) args[0], (Request.Options)args[1], proceedingJoinPoint::proceed);
    }
}
